/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.MD5;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TencentQBSupplier
extends BaseSupplier2
implements Supplier {
    private static Logger logger = LoggerFactory.getLogger(TencentQBSupplier.class);
    private String apiUrl;
    private String mchId;
    private String encKey;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static SupplierData.SupplierExchangeRequest buildRequestData(String orderNum, String qq, Integer quantity) {
        TencentQBRequest req = new TencentQBRequest(orderNum, qq, quantity);
        return req;
    }

    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("qb-tencent")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662fQb\u5151\u6362\u8ba2\u5355");
        }
        String url = this.apiUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        TencentQBRequest request = null;
        TencentQBResponse resp = new TencentQBResponse();
        if (!(req instanceof TencentQBRequest)) {
            throw new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        request = (TencentQBRequest)req;
        Date now = new Date();
        String mch_id = this.mchId;
        String tran_date = String.valueOf(DateUtils.getDayNumber((Date)now));
        String tran_seq = request.getOrderNum();
        String in_acct = request.getQq();
        String in_acct_type = "0";
        String sell_type = "1";
        String sell_sub_type = "0";
        String num = String.valueOf(request.getQuantity());
        String ret_type = "1";
        String ret_url = "";
        String time = String.valueOf(now.getTime() / 1000L);
        String code = TencentQBSupplier.code(mch_id, tran_seq, tran_date, in_acct, in_acct_type, sell_type, sell_sub_type, num, ret_type, ret_url, time);
        String sign = MD5.md5(code + "||" + this.encKey);
        String completeUrl = url = url + code + "&sign=" + sign;
        String body = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(completeUrl);
            get.setConfig(this.getTimeoutConfig());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"gbk");
            resp.setSupplierBody(body);
            so.setSupplierInfo(body);
            String[] returnStrs = body.split("&");
            String retCode = null;
            String retSign = null;
            if (returnStrs[0].startsWith("ret")) {
                retCode = returnStrs[0].split("=")[1];
            }
            if (returnStrs[11].startsWith("sign")) {
                retSign = returnStrs[11].split("=")[1];
            }
            if (StringUtils.isBlank((String)retCode) || StringUtils.isBlank(retSign)) {
                throw new Exception("tencent\u54cd\u5e94\u5f02\u5e38\uff01");
            }
            if (!this.retSignVerify(returnStrs)) {
                throw new Exception("tencent\u54cd\u5e94\u7b7e\u540d\u4e0d\u901a\u8fc7\uff01");
            }
            Map<String, Object> resultMap = this.resolveResult(retCode);
            resp.setSupplierBizId(null);
            if (resultMap.get("ifStopOrder") == null) {
                resp.setSuccess(true);
            } else if (((Boolean)resultMap.get("ifStopOrder")).booleanValue()) {
                so.setErrorMessage((String)resultMap.get("message"));
            } else {
                resp.setError4Admin("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + resultMap.get("message"));
                resp.setError4Developer("\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + resultMap.get("message"));
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c" + resultMap.get("message"));
                so.setErrorMessage((String)resultMap.get("message"));
                resp.setFail(true);
            }
            TencentQBResponse tencentQBResponse = resp;
            return tencentQBResponse;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ("create".equals(so.getStatus())) {
                so.setStatus("send");
            }
            so.setSendTime(now);
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setSendTime(so.getSendTime());
            so4u.setStatus(so.getStatus());
            so4u.setSupplierInfo(so.getSupplierInfo());
            so4u.setErrorMessage(so.getErrorMessage());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(completeUrl);
                log.setGmtCreate(now);
                log.setGmtModified(now);
                if (log.getResp() != null) {
                    log.setSuccess(Boolean.valueOf(true));
                }
                StatHttpRequestLog.log(log);
            }
        }
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        String sign;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("qb-tencent")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662fQb\u5151\u6362\u8ba2\u5355"));
                }
            });
            return;
        }
        String url = this.apiUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        TencentQBRequest request = null;
        if (!(req instanceof TencentQBRequest)) {
            callback.onException(new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e"));
            return;
        }
        request = (TencentQBRequest)req;
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        Date now = new Date();
        String mch_id = this.mchId;
        String tran_date = String.valueOf(DateUtils.getDayNumber((Date)now));
        String tran_seq = request.getOrderNum();
        String in_acct = request.getQq();
        String in_acct_type = "0";
        String sell_type = "1";
        String sell_sub_type = "0";
        String num = String.valueOf(request.getQuantity());
        String ret_type = "1";
        String ret_url = "";
        String time = String.valueOf(now.getTime() / 1000L);
        String code = TencentQBSupplier.code(mch_id, tran_seq, tran_date, in_acct, in_acct_type, sell_type, sell_sub_type, num, ret_type, ret_url, time);
        try {
            sign = MD5.md5(code + "||" + this.encKey);
        }
        catch (Exception e1) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e1);
                }
            });
            return;
        }
        String completeUrl = url = url + code + "&sign=" + sign;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("qb-tencent");
        try {
            this.messageService.sendMsg(this.topicConstant.getQbRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("TencentQBSupplier sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        return null;
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        return null;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        return null;
    }

    @Override
    public String getSupplierName() {
        return "qb-tencent";
    }

    public Map<String, Object> resolveResult(String code) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (TencentReturnType.RET_SUCCESS.getValue().equals(code)) {
            resultMap.put("message", TencentReturnType.RET_SUCCESS.getMessage());
        } else if (TencentReturnType.RET_USER_NOT_EXIST.getValue().equals(code)) {
            resultMap.put("ifStopOrder", Boolean.FALSE);
            resultMap.put("message", TencentReturnType.RET_USER_NOT_EXIST.getMessage());
        } else {
            resultMap.put("ifStopOrder", Boolean.TRUE);
            resultMap.put("message", TencentReturnType.getMessage(code));
        }
        return resultMap;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    public static String code(String mch_id, String tran_seq, String tran_date, String in_acct, String in_acct_type, String sell_type, String sell_sub_type, String num, String ret_type, String ret_url, String time) {
        String code = "mch_id=" + mch_id + "&tran_seq=" + tran_seq + "&tran_date=" + tran_date + "&in_acct=" + in_acct + "&in_acct_type=" + in_acct_type + "&sell_type=" + sell_type + "&sell_sub_type=" + sell_sub_type + "&num=" + num + "&ret_type=" + ret_type + "&ret_url=" + ret_url + "&time=" + time;
        return code;
    }

    private boolean retSignVerify(String[] returnStrs) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String it : returnStrs) {
            String[] mm = it.split("=");
            if (mm.length == 1) {
                params.put(it.split("=")[0], "");
                continue;
            }
            params.put(it.split("=")[0], it.split("=")[1]);
        }
        String string = "ret=" + (String)params.get("ret") + "&" + "mch_id=" + (String)params.get("mch_id") + "&" + "tran_date=" + (String)params.get("tran_date") + "&" + "tran_seq=" + (String)params.get("tran_seq") + "&" + "in_acct=" + (String)params.get("in_acct") + "&" + "in_acct_type=" + (String)params.get("in_acct_type") + "&" + "sell_type=" + (String)params.get("sell_type") + "&" + "sell_sub_type=" + (String)params.get("sell_sub_type") + "&" + "num=" + (String)params.get("num") + "&" + "time=" + (String)params.get("time") + "||" + this.encKey;
        String verify = MD5.md5(string);
        if (verify.equals(sign = (String)params.get("sign"))) {
            return true;
        }
        return "test".equals(params.get("duiba_test"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse response) throws Exception {
        String body = response.getBody();
        String[] returnStrs = body.split("&");
        String retCode = null;
        String retSign = null;
        if (returnStrs[0].startsWith("ret")) {
            retCode = returnStrs[0].split("=")[1];
        }
        if (returnStrs[11].startsWith("sign")) {
            retSign = returnStrs[11].split("=")[1];
        }
        if (StringUtils.isBlank((String)retCode) || StringUtils.isBlank(retSign)) {
            throw new Exception("tencent\u54cd\u5e94\u5f02\u5e38\uff01");
        }
        if (!this.retSignVerify(returnStrs)) {
            throw new Exception("tencent\u54cd\u5e94\u7b7e\u540d\u4e0d\u901a\u8fc7\uff01");
        }
        Map<String, Object> resultMap = this.resolveResult(retCode);
        response.setSupplierBizId(null);
        if (resultMap.get("ifStopOrder") == null) {
            response.setSuccess(true);
        } else if (((Boolean)resultMap.get("ifStopOrder")).booleanValue()) {
            Long supplierOrderId = Long.valueOf(response.getSupplierOrderId());
            SupplierOrderDto so4u = new SupplierOrderDto(supplierOrderId);
            so4u.setErrorMessage((String)resultMap.get("message"));
            this.supplierOrdersService.update(so4u);
        } else {
            response.setError4Admin("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + resultMap.get("message"));
            response.setError4Developer("\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + resultMap.get("message"));
            response.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c" + resultMap.get("message"));
            Long supplierOrderId = Long.valueOf(response.getSupplierOrderId());
            SupplierOrderDto so4u = new SupplierOrderDto(supplierOrderId);
            so4u.setErrorMessage((String)resultMap.get("message"));
            this.supplierOrdersService.update(so4u);
            response.setFail(true);
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so = this.supplierOrdersService.find(Long.valueOf(resp.getSupplierOrderId()));
        if ("create".equals(so.getStatus())) {
            so.setStatus("send");
        }
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setSendTime(so.getSendTime());
        so4u.setStatus(so.getStatus());
        so4u.setSupplierInfo(so.getSupplierInfo());
        so4u.setErrorMessage(so.getErrorMessage());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static enum TencentReturnType {
        RET_SUCCESS("0", "\u4e0b\u5355\u6210\u529f"),
        RET_SIGN_WRONG("1", "\u6570\u5b57\u7b7e\u540d\u9519\u8bef\uff08\u68c0\u67e5\u5bc6\u94a5\u662f\u5426\u6b63\u786e\u3001md5\u52a0\u5bc6\u662f\u5426\u6b63\u786e\uff09"),
        RET_ORDER_RETRY("2", "\u8ba2\u5355\u91cd\u590d\u63d0\u4ea4"),
        RET_USER_NOT_EXIST("3", "\u7528\u6237\u5e10\u53f7\u4e0d\u5b58\u5728"),
        RET_SYSTEM_WRONG("4", "\u7cfb\u7edf\u9519\u8bef(\u6307\u7684\u662f\u975e\u5728\u7ebf\u5361\u652f\u4ed8\u903b\u8f91\u7684\u6240\u6709\u9519\u8bef)\u3002\u5982\u679c\u51fa\u73b0\u8be5\u9519\u8bef\uff0c\u6700\u591a\u91cd\u590d\u5c1d\u8bd5\u5145\u503c3\u6b21\uff0c\u5982\u679c\u9519\u8bef\u4f9d\u65e7\uff0c\u5efa\u8bae\u653e\u5f03\u5145\u503c\u6216\u4eba\u5de5\u5e72\u9884\u5904\u7406\u3002"),
        RET_IP_WRONG("5", "IP\u9519\u8bef"),
        RET_KEY_WRONG("6", "\u7528\u6237key\u9519\u8bef"),
        RET_PARAMS_WRONG("7", "\u53c2\u6570\u9519\u8bef"),
        RET_STOKE_NOT_ENOUGH("8", "\u5e93\u5b58\u4e0d\u8db3"),
        RET_USER_STATUS_WRONG("9", "\u7528\u6237\u72b6\u6001\u5f02\u5e38"),
        RET_TIMEOUT("10", "\u8ba2\u5355\u8d85\u65f6"),
        RET_DISABLE("101", "\u6b64\u529f\u80fd\u6682\u65f6\u4e0d\u53ef\u7528"),
        RET_AUTH_NOT_ENOUGH("102", "\u8be5\u5546\u4e1a\u53f7\u6743\u9650\u4e0d\u8db3"),
        RET_SYSTEM_FIXING("103", "\u7cfb\u7edf\u7ef4\u62a4\u4e2d");

        private String value;
        private String message;

        private TencentReturnType(String value, String message) {
            this.value = value;
            this.message = message;
        }

        public static String getMessage(String value) {
            for (TencentReturnType c : TencentReturnType.values()) {
                if (!c.getValue().equals(value)) continue;
                return c.message;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class TencentQBResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class TencentQBRequest
    implements SupplierData.SupplierExchangeRequest {
        private String orderNum;
        private String qq;
        private Integer quantity;

        public TencentQBRequest(String orderNum, String qq, Integer quantity) {
            this.orderNum = orderNum;
            this.qq = qq;
            this.quantity = quantity;
        }

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public String getQq() {
            return this.qq;
        }

        public void setQq(String qq) {
            this.qq = qq;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }
    }
}

