/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.bean.PriceDegree;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualSupplier2
extends BaseSupplier2
implements Supplier {
    private String appKey;
    private String secretKey;
    @Autowired
    private RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static SupplierData.SupplierExchangeRequest buildRequestData(String orderNum, String params) {
        VirtualRequest req = new VirtualRequest(orderNum, params);
        return req;
    }

    @Override
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        VirtualResponse resp = new VirtualResponse();
        resp.setSupplierBody("");
        resp.setSupplierBizId(order.getDeveloperBizId());
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        AppDO app = this.remoteAppService.find(order.getAppId());
        if (StringUtils.isBlank((String)app.getVirtualExchangeUrl())) {
            final VirtualResponse resp = new VirtualResponse();
            resp.setSupplierBody("");
            resp.setSupplierBizId(order.getDeveloperBizId());
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onFinish(resp);
                }
            });
            return;
        }
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("developer-virtual")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u865a\u62df\u5546\u54c1\u8ba2\u5355"));
                }
            });
            return;
        }
        ConsumerDO consumer = this.remoteConsumerService.find(order.getConsumerId());
        VirtualRequest req = null;
        if (!(request instanceof VirtualRequest)) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e"));
                }
            });
            return;
        }
        req = (VirtualRequest)request;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", app.getAppKey());
        map.put("uid", consumer.getPartnerUserId());
        map.put("orderNum", req.getOrderNum());
        map.put("developBizId", order.getDeveloperBizId());
        map.put("params", req.getDegree());
        map.put("timestamp", String.valueOf(new Date().getTime()));
        map.put("appSecret", app.getAppSecret());
        map.put("description", order.getBrief() + this.getSourceName(order));
        if (StringUtils.isNotBlank((String)req.getUsername())) {
            map.put("account", req.getUsername());
        }
        String sign = SignTool.sign(map);
        map.put("sign", sign);
        map.remove("appSecret");
        String url = "";
        try {
            url = AssembleTool.assembleUrl((String)app.getVirtualExchangeUrl(), map);
        }
        catch (Exception e) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e);
                }
            });
            return;
        }
        String completeUrl = url;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("developer-virtual");
        try {
            this.messageService.sendMsg(this.topicConstant.getVirtualRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e1) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private String getSourceName(OrdersDto order) {
        OperatingActivityDto opDo = null;
        if (order.getChargeMode().equals("hdtool") || order.getChargeMode().equals("singlelottery") || order.getChargeMode().equals("turntable")) {
            opDo = this.remoteOperatingActivityServiceNew.find(order.getRelationId());
        }
        if (order.getChargeMode().equals("game")) {
            return "(\u6e38\u620f\u6d3b\u52a8)";
        }
        if (order.getChargeMode().equals("hdtool")) {
            if (opDo != null && opDo.getTitle() != null && opDo.getType() != null) {
                if (opDo.getType() == 7) {
                    return "(\u522e\u522e\u5361," + opDo.getTitle() + ")";
                }
                if (opDo.getType() == 9) {
                    return "(\u6447\u5956\u673a," + opDo.getTitle() + ")";
                }
                if (opDo.getType() == 6) {
                    return "(\u6447\u4e00\u6447," + opDo.getTitle() + ")";
                }
                if (opDo.getType() == 8) {
                    return "(\u5e78\u8fd0\u8f6c\u76d8," + opDo.getTitle() + ")";
                }
            }
            return "(\u6d3b\u52a8\u5de5\u5177)";
        }
        if (order.getChargeMode().equals("manuallottery")) {
            return "(\u624b\u52a8\u62bd\u5956)";
        }
        if (order.getChargeMode().equals("singlelottery")) {
            if (opDo != null && opDo.getTitle() != null) {
                return "(\u5355\u54c1\u62bd\u5956," + opDo.getTitle() + ")";
            }
            return "(\u5355\u54c1\u62bd\u5956)";
        }
        if (order.getChargeMode().equals("turntable")) {
            if (opDo != null && opDo.getTitle() != null) {
                return "(\u5e78\u8fd0\u8f6c\u76d8," + opDo.getTitle() + ")";
            }
            return "(\u5e78\u8fd0\u8f6c\u76d8)";
        }
        return "(\u666e\u901a\u5151\u6362)";
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        return null;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        return null;
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("orderNum");
        OrdersDto order = this.orderReadManagerBo.findByOrderNum(orderNum);
        if ("virtual".equals(order.getType())) {
            if ("true".equalsIgnoreCase(request.getParameter("success"))) {
                ret.setSuccess(true);
            } else if ("false".equalsIgnoreCase(request.getParameter("success"))) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "developer";
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse response) throws Exception {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(response.getSupplierOrderId()));
        String body = response.getBody();
        so4u.setSupplierInfo(body);
        this.supplierOrdersService.update(so4u);
        if (body == null) {
            throw new Exception("response body is null");
        }
        JSONObject json = JSON.parseObject((String)body);
        if (null == json) {
            throw new Exception("\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
        }
        String status = json.getString("status");
        if ("success".equals(status)) {
            String bizId;
            Long credits = json.getLongValue("credits");
            if (credits != null && credits >= 0L) {
                this.remoteConsumerService.updateCredits(Long.valueOf(response.getConsumerId()), credits);
            }
            if (StringUtils.isNotBlank((String)(bizId = json.getString("supplierBizId")))) {
                response.setSupplierBizId(bizId);
            }
            response.setSuccess(true);
        } else if ("process".equals(status)) {
            String bizId;
            Long credits = json.getLongValue("credits");
            if (credits != null && credits >= 0L) {
                this.remoteConsumerService.updateCredits(Long.valueOf(response.getConsumerId()), credits);
            }
            if (StringUtils.isNotBlank((String)(bizId = json.getString("supplierBizId")))) {
                response.setSupplierBizId(bizId);
            }
        } else if ("fail".equals(status)) {
            String bizId = json.getString("supplierBizId");
            if (StringUtils.isNotBlank((String)bizId)) {
                response.setSupplierBizId(bizId);
            }
            response.setError4Admin("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\u8bf7\u8054\u7cfb\u4e0a\u6e38");
            String errorMsg = json.getString("errorMessage");
            response.setError4Developer(errorMsg);
            response.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            response.setFail(true);
        } else {
            response.setError4Admin("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38");
            response.setError4Developer("\u5145\u503c\u5f02\u5e38,\u72b6\u6001\u65e0\u8fd4\u56de\u503c");
            response.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        Long supplierOrderId = Long.valueOf(resp.getSupplierOrderId());
        SupplierOrderDto so = this.supplierOrdersService.find(supplierOrderId);
        if ("create".equals(so.getStatus())) {
            so.setStatus("send");
        }
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(supplierOrderId);
        so4u.setSendTime(so.getSendTime());
        so4u.setStatus(so.getStatus());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class VirtualResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class VirtualRequest
    implements SupplierData.SupplierExchangeRequest {
        private String orderNum;
        private String degree;
        private String username;

        public VirtualRequest(String orderNum, String params) {
            this.orderNum = orderNum;
            this.degree = PriceDegree.getDegree(params);
            this.username = PriceDegree.getAccount(params);
        }

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public String getDegree() {
            return this.degree;
        }

        public void setDegree(String degree) {
            this.degree = degree;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

