/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.notify.impl;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.dao.notify.NotifyQueueDao;
import cn.com.duiba.order.center.biz.entity.consumer.NotifyQueueEntity;
import cn.com.duiba.order.center.biz.service.notify.NotifyQueueInsertService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotifyQueueInsertServiceImpl
implements NotifyQueueInsertService {
    private static Logger log = LoggerFactory.getLogger(NotifyQueueInsertServiceImpl.class);
    @Autowired
    private NotifyQueueDao notifyQueueDAO;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Resource
    private RemoteConsumerService remoteConsumerService;

    @Override
    public void insertMainOrderNotifyQueueIfNesscery(Long orderId, Long consumerId) {
        try {
            OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
            if ("turntable".equals(order.getChargeMode())) {
                return;
            }
            if ("singlelottery".equals(order.getChargeMode())) {
                return;
            }
            if ("manuallottery".equals(order.getChargeMode())) {
                return;
            }
            if ("hdtool".equals(order.getChargeMode())) {
                return;
            }
            if ("game".equals(order.getChargeMode())) {
                return;
            }
            if ("question".equals(order.getChargeMode())) {
                return;
            }
            if ("quizz".equals(order.getChargeMode())) {
                return;
            }
            if ("guess".equals(order.getChargeMode())) {
                return;
            }
            if ("ngame".equals(order.getChargeMode())) {
                return;
            }
            if ("activity".equals(order.getChargeMode())) {
                return;
            }
            if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus())) {
                return;
            }
            ConsumerDO consumer = this.remoteConsumerService.find(order.getConsumerId());
            NotifyQueueEntity nq = new NotifyQueueEntity();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum(order.getOrderNum());
            if (order.getError4Developer() != null) {
                nq.setError4developer(order.getError4Developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getId());
            nq.setRelationType("orders");
            nq.setResult("success".equals(order.getStatus()));
            nq.setTimes(0);
            this.notifyQueueDAO.insert(nq);
        }
        catch (Exception e) {
            log.error("insertNotifyQueueIfNesscery error", (Throwable)e);
        }
    }
}

