/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork;

import cn.com.duiba.order.center.api.dto.flowwork.FlowworkStage;
import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.utils.FlowworkTool;
import cn.com.duiba.order.center.biz.service.orders.consumer.ConsumerOrdersJumpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowworkJumpTool {
    @Autowired
    public ConsumerOrdersJumpService consumerOrdersJumpService;

    public boolean ifCanThenJump(OrdersDto order) throws Exception {
        FlowworkStage stage = FlowworkTool.getStage((OrdersDto)order);
        if (this.checkCreateStarted2DuibaPayComplete(order, stage)) {
            int ret = this.consumerOrdersJumpService.jumpCreateStarted2DuibaPayComplete(order.getId(), order.getConsumerId());
            return ret == 1;
        }
        if (this.checkCreateStarted2DeveloperPayComplete(order, stage)) {
            int ret = this.consumerOrdersJumpService.jumpCreateStarted2DeveloperPayComplete(order.getId(), order.getConsumerId());
            return ret == 1;
        }
        if (this.checkDeveloperPayStarted2DuibaPayComplete(order, stage)) {
            int ret = this.consumerOrdersJumpService.jumpDeveloperPayStarted2DuibaPayComplete(order.getId(), order.getConsumerId());
            return ret == 1;
        }
        if (this.checkConsumeCreditsStarted2AuditComplete(order, stage)) {
            int ret = this.consumerOrdersJumpService.jumpConsumeCreditsStarted2AuditComplete(order.getId(), order.getConsumerId());
            return ret == 1;
        }
        if (this.checkConsumeCreditsStarted2ConsumerPayComplete(order, stage)) {
            int ret = this.consumerOrdersJumpService.jumpConsumeCreditsStarted2ConsumerPayComplete(order.getId(), order.getConsumerId());
            return ret == 1;
        }
        if (this.checkSupplierExchangeStarted2AfterSendComplete(order, stage)) {
            int ret = this.consumerOrdersJumpService.jumpSupplierExchangeStarted2AfterSendComplete(order.getId(), order.getConsumerId());
            return ret == 1;
        }
        return false;
    }

    private boolean checkCreateStarted2DuibaPayComplete(OrdersDto order, FlowworkStage stage) {
        return 0 == order.getActualPrice() && "none".equals(order.getPayStatus()) && 0 == order.getDuibaActualPrice() && "none".equals(order.getDuibaPayStatus()) && NodeType.Create.equals((Object)stage.nodeType);
    }

    private boolean checkCreateStarted2DeveloperPayComplete(OrdersDto order, FlowworkStage stage) {
        return order.getActualPrice() == 0 && "none".equals(order.getPayStatus()) && order.getDuibaActualPrice() > 0 && NodeType.Create.equals((Object)stage.nodeType);
    }

    private boolean checkDeveloperPayStarted2DuibaPayComplete(OrdersDto order, FlowworkStage stage) {
        return order.getDuibaActualPrice() == 0 && "none".equals(order.getDuibaPayStatus()) && order.getActualPrice() > 0 && NodeType.DeveloperPay.equals((Object)stage.nodeType);
    }

    private boolean checkConsumeCreditsStarted2ConsumerPayComplete(OrdersDto order, FlowworkStage stage) {
        return order.getConsumerPayPrice() == 0L && "none".equals(order.getConsumerPayStatus()) && order.getAuditStatus() != null && NodeType.ConsumeCredits.equals((Object)stage.nodeType);
    }

    private boolean checkConsumeCreditsStarted2AuditComplete(OrdersDto order, FlowworkStage stage) {
        return order.getConsumerPayPrice() == 0L && "none".equals(order.getConsumerPayStatus()) && order.getAuditStatus() == null && NodeType.ConsumeCredits.equals((Object)stage.nodeType);
    }

    private boolean checkSupplierExchangeStarted2AfterSendComplete(OrdersDto order, FlowworkStage stage) {
        return order.getConsumerPayPrice() == 0L && "none".equals(order.getConsumerPayStatus()) && NodeType.SupplierExchange.equals((Object)stage.nodeType);
    }
}

