/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFlowWorker
extends BaseFlowWorker {
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, ExecutorService es) throws Exception {
        int complete;
        int ret = this.flowworkStatusChangeService.changeConsumerPay2Audit(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
        }
        OrdersDto order = this.getOrder(orderId, consumerId);
        if (order.getAuditStatus() == null && (complete = this.flowworkStatusChangeService.markAuditComplete(orderId, consumerId)) == 1) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(orderId, consumerId);
                }
            });
        }
    }

    public void auditPass(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        boolean success = this.ordersStatusChangeBo.doAuditPass(order);
        if (!success) {
            throw new Exception("\u5ba1\u6838\u5931\u8d25");
        }
        int ret = this.flowworkStatusChangeService.markAuditComplete(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u5ba1\u6838\u51fa\u9519");
        }
        this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderAuditPass, this.getOrder(orderId, consumerId)));
    }

    public void auditReject(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        boolean success = this.ordersStatusChangeBo.doAuditReject(orderId, consumerId);
        if (!success) {
            throw new Exception("\u5ba1\u6838\u5931\u8d25");
        }
        int ret = this.flowworkStatusChangeService.changeAudit2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u5ba1\u6838\u51fa\u9519");
        }
        this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderAuditReject, this.getOrder(orderId, consumerId)));
    }

    public void makeAuditFail(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.changeAudit2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u5ba1\u6838\u51fa\u9519");
        }
        DuibaEventsDispatcher.get().dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderAuditReject, this.getOrder(orderId, consumerId)));
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.Audit;
    }
}

