/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.FlowworkStage;
import cn.com.duiba.order.center.api.dto.flowwork.NodeSubStatus;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.utils.FlowworkTool;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.OrdersStatusChangeBo;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowworkEngine;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowworkStatusChangeService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseFlowWorker
implements FlowWorker {
    @Autowired
    protected OrdersStatusChangeBo ordersStatusChangeBo;
    @Autowired
    protected OrderReadManagerBo orderReadManagerBo;
    @Autowired
    protected FlowworkStatusChangeService flowworkStatusChangeService;
    @Autowired
    public FlowworkEngine flowworkEngine;

    protected OrdersDto checkStayAtMyNode(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        FlowworkStage stage = FlowworkTool.getStage((OrdersDto)order);
        if (stage == null) {
            if (this.compatibleOldOrderCheck(order)) {
                int ret = this.flowworkStatusChangeService.compatibleOldOrderStatus(orderId, consumerId, this.getMyNodeType());
                if (ret != 1) {
                    throw new Exception("\u51fa\u9519\u4e86");
                }
                return this.getOrder(orderId, consumerId);
            }
            new Exception("\u672a\u77e5\u6d41\u7a0b\u8282\u70b9");
        } else if (this.isRightStageAndStarted(order)) {
            return order;
        }
        throw new Exception("\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u8be5\u6d41\u7a0b\u8282\u70b9");
    }

    protected boolean compatibleOldOrderCheck(OrdersDto order) {
        return true;
    }

    protected OrdersDto getOrder(Long orderId, Long consumerId) {
        return this.orderReadManagerBo.find(orderId, consumerId);
    }

    private boolean isRightStageAndStarted(OrdersDto order) {
        FlowworkStage stage = FlowworkTool.getStage((OrdersDto)order);
        return stage.nodeType == this.getMyNodeType() && stage.nodeSubStatus == NodeSubStatus.Started;
    }
}

