/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.core.event.ConsumeCreditsFailEvent;
import cn.com.duiba.order.center.biz.core.event.ConsumerCreditsSuccessEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.order.center.biz.service.exchange2.tool.ConsumeCreditsCallback;
import cn.com.duiba.order.center.biz.service.exchange2.tool.ToDeveloperTool2;
import cn.com.duiba.order.center.biz.service.log.ConsumeCreditsLog;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterLastSendService;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumeCreditsFlowWorker
extends BaseFlowWorker {
    private static Logger log = LoggerFactory.getLogger(ConsumeCreditsFlowWorker.class);
    @Autowired
    private ToDeveloperTool2 toDeveloperTool2;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private OrdersFasterLastSendService ordersFasterLastSendService;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public void asyncStart(Long orderId, Long consumerId, CompleteListener listener, ExecutorService es) throws Exception {
        int ret = this.flowworkStatusChangeService.changeDuibaPay2ConsumeCredits(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
        }
        this.toDeveloperTool2.asyncConsumeCredits(orderId, consumerId, new NormalConsumeCreditsCallback(orderId, consumerId, listener), es);
    }

    public void forceKillOrderComplete(Long orderId, Long consumerId) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.markConsumeCreditsComplete(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u51fa\u9519\u4e86");
        }
    }

    public void forceMakeTofail(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.changeConsumeCredits2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u51fa\u9519\u4e86");
        }
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.ConsumeCredits;
    }

    public Integer getOpTypeItem(ItemKey itemKey) {
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(0) || itemKey.getItem().isOpTypeItem(0)) {
                return ItemKeyVO.MARK_TIME;
            }
            if (itemKey.getAppItem().isOpTypeAppItem(9) || itemKey.getItem().isOpTypeItem(9)) {
                return ItemKeyVO.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isItemMode()) {
            if (itemKey.getItem().isOpTypeItem(0)) {
                return ItemKeyVO.MARK_TIME;
            }
            if (itemKey.getItem().isOpTypeItem(9)) {
                return ItemKeyVO.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(9)) {
                return ItemKeyVO.MARK_ADDRLIMIT;
            }
            if (itemKey.getAppItem().isOpTypeAppItem(0)) {
                return ItemKeyVO.MARK_TIME;
            }
            if (itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeSingleLottery || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeOperatingActivity || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeManualLottery || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeAppShakeLottery || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeHdtoolTiger || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeHdtoolTurntable || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeGameSanta || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeGameYearAward || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeGameGirl || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeGameJiong || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeDuibaQuestionAnswer || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeDuibaQuizz || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeNgame || itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeGuess) {
                return ItemKeyVO.MARK_LOTTERY;
            }
            if (itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeDuibaActivityItem) {
                ItemKey duibaActivityItemKey = this.remoteItemKeyService.getItemKey(itemKey.getAppItem().getSourceRelationId(), null, itemKey.getApp());
                if (duibaActivityItemKey.getItem().isOpTypeItem(0)) {
                    return ItemKeyVO.MARK_TIME;
                }
                if (duibaActivityItemKey.getItem().isOpTypeItem(1)) {
                    return ItemKeyVO.MARK_QUANTITY;
                }
            } else if (itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeDuibaActivitySingleLottery) {
                return ItemKeyVO.MARK_LOTTERY;
            }
        }
        return ItemKeyVO.MARK_NORMAL;
    }

    private class NormalConsumeCreditsCallback
    implements ConsumeCreditsCallback {
        private Long orderId;
        private Long consumerId;
        private CompleteListener listener;

        public NormalConsumeCreditsCallback(Long orderId, Long consumerId, CompleteListener listener) {
            this.orderId = orderId;
            this.consumerId = consumerId;
            this.listener = listener;
        }

        @Override
        public void onSuccess() {
            boolean success;
            try {
                success = ConsumeCreditsFlowWorker.this.ordersStatusChangeBo.doMakeConsumeSuccess(this.orderId, this.consumerId);
            }
            catch (Exception e) {
                log.error("doMakeConsumeSuccess error \u4e0d\u5f80\u4e0b\u6267\u884c\u4ee3\u7801", (Throwable)e);
                return;
            }
            if (success) {
                try {
                    OrdersDto order = ConsumeCreditsFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
                    ConsumeCreditsFlowWorker.this.duibaEventsDispatcher.dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(order));
                    ConsumeCreditsFlowWorker.this.flowworkStatusChangeService.markConsumeCreditsComplete(this.orderId, this.consumerId);
                    this.listener.onComplete(this.orderId, this.consumerId);
                }
                catch (Exception e) {
                    log.error("flowworkStatusChangeService.markConsumeCreditsComplete error", (Throwable)e);
                }
            }
        }

        @Override
        public void onFail(Exception e) {
            this.processFail(e);
            OrdersDto order = ConsumeCreditsFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
            ConsumeCreditsFlowWorker.this.duibaEventsDispatcher;
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, e));
        }

        private void processFail(Exception e) {
            OrdersDto order = ConsumeCreditsFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
            if (e instanceof DeveloperConsumeFailedException && ((DeveloperConsumeFailedException)e).getNormalFail().booleanValue()) {
                boolean success;
                ConsumeCreditsLog.info("\u6263\u79ef\u5206\u5931\u8d25 orderId=" + order.getId() + ", errorMsg=" + e.getMessage());
                try {
                    success = ConsumeCreditsFlowWorker.this.ordersStatusChangeBo.doMakeConsumeFail(this.orderId, this.consumerId, 3, "\u5151\u6362\u5931\u8d25\uff0c" + e.getMessage(), "\u5151\u6362\u5931\u8d25\uff0c" + e.getMessage(), "\u6263\u79ef\u5206\u5931\u8d25:" + e.getMessage());
                }
                catch (Exception e2) {
                    log.error("\u6263\u79ef\u5206\u5931\u8d25\uff0c\u53d8\u66f4\u72b6\u6001\u5931\u8d25", (Throwable)e2);
                    return;
                }
                if (success) {
                    try {
                        int ret = ConsumeCreditsFlowWorker.this.flowworkStatusChangeService.changeConsumeCredits2Fail(this.orderId, this.consumerId);
                        if (ret == 1) {
                            this.listener.onComplete(this.orderId, this.consumerId);
                            return;
                        }
                    }
                    catch (Exception e1) {
                        log.error("flowworkStatusChangeService.changeConsumeCredits2Fail error", (Throwable)e);
                    }
                }
            } else {
                boolean success;
                ConsumeCreditsLog.info("\u6263\u79ef\u5206\u5931\u8d25 orderId=" + order.getId(), e);
                try {
                    success = ConsumeCreditsFlowWorker.this.ordersStatusChangeBo.doMakeConsumeFail(this.orderId, this.consumerId, 2, e.getMessage(), "\u6263\u79ef\u5206\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u670d\u52a1\u5668\u5f02\u5e38\u3002" + e.getMessage(), "\u6263\u79ef\u5206\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u670d\u52a1\u5668\u5f02\u5e38\u3002" + e.getMessage());
                }
                catch (Exception e2) {
                    log.error("\u6263\u79ef\u5206\u5931\u8d25\uff0c\u53d8\u66f4\u72b6\u6001\u51fa\u9519", (Throwable)e2);
                    return;
                }
                if (success) {
                    OrdersDto orderDO = ConsumeCreditsFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
                    ItemKey itemKey = ConsumeCreditsFlowWorker.this.remoteItemKeyService.getItemKeyIncludeDeleted(orderDO.getItemId(), orderDO.getAppItemId(), orderDO.getAppId());
                    if (ItemKeyVO.MARK_TIME == ConsumeCreditsFlowWorker.this.getOpTypeItem(itemKey)) {
                        if (orderDO.getConsumerPayPrice() > 0L) {
                            try {
                                int ret = ConsumeCreditsFlowWorker.this.flowworkStatusChangeService.changeConsumeCredits2Fail(this.orderId, this.consumerId);
                                if (ret == 1) {
                                    this.listener.onComplete(this.orderId, this.consumerId);
                                    return;
                                }
                                log.error("orderId=" + this.orderId + ",flowworkStatusChangeService.changeConsumeCredits2Fail fail", (Throwable)new Exception("changeConsumeCredits2Fail error"));
                            }
                            catch (Exception e1) {
                                log.error("flowworkStatusChangeService.changeConsumeCredits2Fail error", (Throwable)e1);
                            }
                        } else {
                            ConsumeCreditsFlowWorker.this.ordersFasterLastSendService.addSecondKillOrder(orderDO);
                        }
                        return;
                    }
                    try {
                        int ret = ConsumeCreditsFlowWorker.this.flowworkStatusChangeService.changeConsumeCredits2Fail(this.orderId, this.consumerId);
                        if (ret == 1) {
                            this.listener.onComplete(this.orderId, this.consumerId);
                            return;
                        }
                        log.error("orderId=" + this.orderId + ",flowworkStatusChangeService.changeConsumeCredits2Fail fail", (Throwable)new Exception("changeConsumeCredits2Fail error"));
                    }
                    catch (Exception e1) {
                        log.error("flowworkStatusChangeService.changeConsumeCredits2Fail error", (Throwable)e1);
                    }
                }
            }
        }
    }
}

