/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumerPayFlowWorker
extends BaseFlowWorker {
    private static Logger logger = LoggerFactory.getLogger(ConsumerPayFlowWorker.class);
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, ExecutorService es) throws Exception {
        OrdersDto ordersDO = this.getOrder(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.changeConsumeCredits2ConsumerPay(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
        }
        if (ordersDO.getConsumerPayPrice() > 0L && "wait_pay".equals(ordersDO.getConsumerPayStatus())) {
            try {
                this.ambOrderFastBo.createOrderFastWaitPay(ordersDO.getId(), consumerId, ordersDO.getGmtCreate());
                return;
            }
            catch (Exception e) {
                logger.error("make order fast wait pay is error!", (Throwable)e);
                return;
            }
        }
        this.flowworkStatusChangeService.markConsumerPayComplete(orderId, consumerId);
        es.submit(new Runnable(){

            @Override
            public void run() {
                listener.onComplete(orderId, consumerId);
            }
        });
    }

    public void doAmbPaySuccess(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (order.getConsumerPayPrice() <= 0L) {
            throw new Exception("\u975e\u52a0\u94b1\u8d2d \u5b9a\u5355");
        }
        boolean success = this.ordersStatusChangeBo.doAmbPaySuccess(orderId, consumerId);
        if (!success) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25");
        }
        int ret = this.ambSubOrdersService.updateSettleStatusWaitSettleBySubId(order.getSubOrderId());
        if (ret == 0) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25");
        }
        this.flowworkStatusChangeService.markConsumerPayComplete(orderId, consumerId);
    }

    public void payTimeout(Long orderId, Long consumerId) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.changeConsumerPay2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u51fa\u9519\u4e86");
        }
    }

    public void consumerCancelOrder(Long orderId, Long consumerId) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.changeConsumerPay2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u51fa\u9519\u4e86");
        }
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.ConsumerPay;
    }
}

