/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.service.email.EmailService;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersStatusChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.master.MasterOrdersPayCenterExceptionService;
import cn.com.duiba.paycenter.client.DuibaPayOrdersServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.dto.DuibaDeduceDetailDto;
import cn.com.duiba.paycenter.params.DuibaPayOrdersExtraParams;
import cn.com.duiba.paycenter.remoteservice.RemoteDuibaDeduceDetailService;
import cn.com.duiba.paycenter.result.PayOrdersResult;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import com.google.common.base.Objects;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DuibaPayFlowWorker
extends BaseFlowWorker {
    private static Logger log = LoggerFactory.getLogger(DuibaPayFlowWorker.class);
    @Autowired
    private DuibaPayOrdersServiceClient duibaPayOrdersServiceClient;
    @Autowired
    private RemoteDuibaDeduceDetailService remoteDuibaDeduceDetailService;
    @Autowired
    private RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private MasterOrdersPayCenterExceptionService masterOrdersPayCenterExceptionService;
    @Autowired
    private OrdersStatusChangeService ordersStatusChangeService;
    private ExecutorService callpool = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private int i;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "DuibaPayFlowWorker-" + this.i++);
        }
    });

    public int dumpSize() {
        Integer activeThread = ((ThreadPoolExecutor)this.callpool).getActiveCount();
        return activeThread;
    }

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, final ExecutorService es) throws Exception {
        int ret = this.flowworkStatusChangeService.changeDeveloperPay2DuibaPay(orderId, consumerId);
        if (ret == 1) {
            final OrdersDto order = this.getOrder(orderId, consumerId);
            if (order.getDuibaActualPrice() == 0 && "none".equals(order.getDuibaPayStatus())) {
                int complete = this.flowworkStatusChangeService.markDuibaPayComplete(orderId, consumerId);
                if (complete == 1) {
                    es.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(orderId, consumerId);
                        }
                    });
                }
            } else if (order.getDuibaActualPrice() > 0 && "wait_pay".equals(order.getDuibaPayStatus())) {
                this.callpool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DuibaPayFlowWorker.this.callDuibaPayCenter(order, listener, es);
                        }
                        catch (Exception e) {
                            log.error("call pay center ", (Throwable)e);
                        }
                    }
                });
            } else {
                throw new Exception("\u72b6\u6001\u5f02\u5e38");
            }
        }
    }

    public void retryDuibaPay(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        if (order.getDuibaActualPrice() > 0) {
            this.callDuibaPayCenter(order, this.flowworkEngine.getGoingListener(), this.flowworkEngine.getExecutorService());
        }
    }

    public void forceMakeFail(Long orderId, Long consumerId) throws Exception {
        this.flowworkStatusChangeService.changeDuibaPay2Fail(orderId, consumerId);
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.DuibaPay;
    }

    private void callDuibaPayCenter(final OrdersDto order, final CompleteListener listener, ExecutorService es) throws Exception {
        DuibaPayOrdersExtraParams pa = new DuibaPayOrdersExtraParams();
        pa.setAppId(order.getAppId());
        pa.setDeveloperId(order.getDeveloperId());
        DuibaDeduceDetailDto detail = this.genDuibaDeduceDetail(order);
        RpcResult result = this.duibaPayOrdersServiceClient.payOrder(order.getId(), Long.valueOf(order.getDuibaActualPrice().intValue()), pa);
        if (!result.isOpSuccess()) {
            PayCenterLog.error("call duibaPayOrdersServiceClient.payOrder  exception developId " + order.getDeveloperId(), (Throwable)result.getRpcException());
            for (int i = 0; i < OrdersDto.try_again_count; ++i) {
                Uninterruptibles.sleepUninterruptibly((long)OrdersDto.try_again_interval_time.intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                result = this.duibaPayOrdersServiceClient.payOrder(order.getId(), Long.valueOf(order.getDuibaActualPrice().intValue()), pa);
                if (result.isOpSuccess()) break;
                PayCenterLog.error("call duibaPayOrdersServiceClient.payOrder  exception developId: " + order.getDeveloperId() + " try again " + i, (Throwable)result.getRpcException());
            }
            if (!result.isOpSuccess()) {
                this.masterOrdersPayCenterExceptionService.insert(order, "wait_pay \u5151\u5427\u5e10\u6237   \u4e0b\u5355\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3 \u5c1d\u8bd5\u4e09\u6b21\u4e4b\u540e\u5907\u4efd");
                PayCenterLog.error("try again " + OrdersDto.try_again_count + " failed" + "  call duibaPayOrdersServiceClient.payOrder  exception developId:" + order.getDeveloperId() + "  money:  " + order.getDuibaActualPrice() + "  ordersID : " + order.getId(), (Throwable)result.getRpcException());
                this.remoteDuibaDeduceDetailService.updateDuibaDeduceDetail(detail.getId(), "unknow");
                String text = "developId: " + order.getDeveloperId() + "  money:  " + order.getDuibaActualPrice() + "  ordersID : " + order.getId();
                text = text + "  duibaPayOrdersServiceClient.payOrder";
                this.emailService.sendSeriousEmail4PayCenter("\u5411\u652f\u4ed8\u4e2d\u5fc3\u53d1\u9001\u5151\u5427\u652f\u4ed8\u5b9a\u5355\u7f51\u7edc\u5f02\u5e38\uff0c\u7b49\u5f85\u5904\u7406", text);
                throw new RuntimeException("\u548c\u652f\u4ed8\u4e2d\u5fc3\u4ea4\u4e92\u5f02\u5e38");
            }
        }
        if (result.isOpSuccess()) {
            if (!((PayOrdersResult)result.getResult()).isBizSuccess()) {
                PayCenterLog.error("call duibaPayOrdersServiceClient.payOrder  is final failed  developId: " + order.getDeveloperId(), ((PayOrdersResult)result.getResult()).getErrorException());
                this.masterOrdersPayCenterExceptionService.insert(order, "wait_pay \u5151\u5427\u5e10\u6237  \u652f\u4ed8\u5931\u8d25   \u5907\u4efd");
                this.remoteDuibaDeduceDetailService.updateDuibaDeduceDetail(detail.getId(), "failed");
                int ret = this.flowworkStatusChangeService.changeDuibaPay2Fail(order.getId(), order.getConsumerId());
                if (ret == 1) {
                    es.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(order.getId(), order.getConsumerId());
                        }
                    });
                }
            } else {
                PayCenterLog.info("call duibaPayOrdersServiceClient.payOrder is successful set pay order status is prereduce");
                this.remoteDuibaDeduceDetailService.updateDuibaDeduceDetail(detail.getId(), "success");
                this.ordersStatusChangeService.updateDuibaPayOrderStatus(order.getId(), order.getConsumerId(), "prereduce");
                int complete = this.flowworkStatusChangeService.markDuibaPayComplete(order.getId(), order.getConsumerId());
                if (complete == 1) {
                    es.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(order.getId(), order.getConsumerId());
                        }
                    });
                }
            }
        }
    }

    private DuibaDeduceDetailDto genDuibaDeduceDetail(OrdersDto order) {
        DuibaDeduceDetailDto detail = new DuibaDeduceDetailDto();
        detail.setOperationStatus("create");
        detail.setAppId(order.getAppId());
        AppDO app = this.remoteAppService.find(order.getAppId());
        String name = app.getName();
        detail.setAppName(name);
        detail.setActivityType(String.valueOf(order.getRelationType()));
        if (!Objects.equal(null, (Object)order.getRelationId())) {
            OperatingActivityDto ado = this.remoteOperatingActivityServiceNew.find(order.getRelationId());
            detail.setActivityId(ado.getActivityId());
            detail.setActivityTitle(ado.getTitle());
        }
        detail.setDevelopId(order.getDeveloperId());
        detail.setOrderNo(order.getOrderNum());
        detail.setOrderId(order.getId().longValue());
        detail.setOperationMoney(Double.valueOf(Double.parseDouble(-order.getDuibaActualPrice().intValue() + "")));
        detail.setMemo("\u8bf7\u6c42\u652f\u4ed8 \u5b9a\u5355");
        detail.setOperationType("pay");
        this.remoteDuibaDeduceDetailService.insert(detail);
        return detail;
    }
}

