/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.FlowworkStage;
import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.utils.FlowworkTool;
import cn.com.duiba.order.center.biz.bo.amb.AmbPaybackBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.notify.NotifyQueueInsertService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FailFlowWorker
extends BaseFlowWorker {
    private static Logger logger = LoggerFactory.getLogger(FailFlowWorker.class);
    @Autowired
    private AmbPaybackBo ambPaybackBo;
    @Autowired
    protected RemoteAppService remoteAppService;
    @Autowired
    protected RemoteConsumerService remoteConsumerService;
    @Autowired
    private NotifyQueueInsertService notifyQueueInsertService;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, ExecutorService es) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        FlowworkStage stage = FlowworkTool.getStage((OrdersDto)order);
        if (stage.nodeType == NodeType.Create) {
            int ret = this.flowworkStatusChangeService.changeCreate2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.DeveloperPay) {
            int ret = this.flowworkStatusChangeService.changeDeveloperPay2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.DuibaPay) {
            int ret = this.flowworkStatusChangeService.changeDuibaPay2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.ConsumeCredits) {
            int ret = this.flowworkStatusChangeService.changeConsumeCredits2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.ConsumerPay) {
            int ret = this.flowworkStatusChangeService.changeConsumerPay2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.Audit) {
            int ret = this.flowworkStatusChangeService.changeAudit2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.SupplierExchange) {
            int ret = this.flowworkStatusChangeService.changeSupplierExchange2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else if (stage.nodeType == NodeType.AfterSend) {
            int ret = this.flowworkStatusChangeService.changeAfterSend2FailStarted(orderId, consumerId);
            if (ret != 1) {
                throw new Exception("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
            }
        } else {
            throw new Exception("\u72b6\u6001\u9519\u8bef");
        }
        this.doWork(order);
        this.flowworkStatusChangeService.markFailComplete(orderId, consumerId);
        es.submit(new Runnable(){

            @Override
            public void run() {
                listener.onComplete(orderId, consumerId);
            }
        });
    }

    private void doWork(OrdersDto tempOrder) throws Exception {
        if ("success".equals(tempOrder.getStatus()) || "fail".equals(tempOrder.getStatus())) {
            throw new Exception("\u72b6\u6001\u5f02\u5e38 " + tempOrder.getStatus());
        }
        boolean success = this.ordersStatusChangeBo.doMakeFail(tempOrder.getId(), tempOrder.getConsumerId());
        if (!success) {
            throw new Exception("\u5931\u8d25\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38");
        }
        OrdersDto order = this.getOrder(tempOrder.getId(), tempOrder.getConsumerId());
        if (order.getConsumerPayPrice() > 0L) {
            try {
                this.ambPaybackBo.createPayBackRecordAtMakeFail(order);
            }
            catch (Exception e) {
                logger.error("\u52a0\u94b1\u8d2d\u521b\u5efa  \u8fd8\u6b3e\u8bb0\u5f55\u5931\u8d25orderId=" + order.getId(), (Throwable)e);
            }
        }
        try {
            this.remoteAppService.restoreBudget((OrdersDto)BeanUtils.copy((Object)order, OrdersDto.class));
            if (order.getCredits() > 0L) {
                this.remoteConsumerService.increaseCredits(order.getConsumerId(), order.getCredits());
            }
            this.notifyQueueInsertService.insertMainOrderNotifyQueueIfNesscery(order.getId(), order.getConsumerId());
            OrdersDto finalOrder = this.getOrder(tempOrder.getId(), tempOrder.getConsumerId());
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderFail, order));
    }

    public void makeFail(Long orderId, Long consumerId) {
        OrdersDto order = this.getOrder(orderId, consumerId);
        try {
            this.doWork(order);
            this.flowworkStatusChangeService.markFailComplete(orderId, consumerId);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.Fail;
    }
}

