/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.activity.center.api.remoteservice.chaos.RemoteRetryOrdersFasterService;
import cn.com.duiba.order.center.api.dto.flowwork.AlipayOrderResponseDetail;
import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.dao.amb.AmbSubOrdersDao;
import cn.com.duiba.order.center.biz.dao.supplier_order.SupplierProductsDao;
import cn.com.duiba.order.center.biz.entity.supplier_order.SupplierProductEntity;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.ObjectSupplier2;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.AlipayOfficialSupplierConnector;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.CouponConnector;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.ObjectConnector;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.PhonebillConnector;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.PhoneflowConnector;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.QBSupplierConnector;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.VirtualConnector;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterLastSendService;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierOrdersService;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import cn.com.duiba.order.center.biz.tool.TakeOrderSwitch;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.CenterConfigDO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemoteAppItemService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteCenterConfigService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupplierExchangeFlowWorker
extends BaseFlowWorker {
    private static Logger log = LoggerFactory.getLogger(SupplierExchangeFlowWorker.class);
    @Autowired
    private QBSupplierConnector qbSupplierConnector;
    @Autowired
    private AlipayOfficialSupplierConnector alipayOfficialSupplierConnector;
    @Autowired
    private CouponConnector couponConnector;
    @Autowired
    private ObjectConnector objectConnector;
    @Autowired
    private VirtualConnector virtualConnector;
    @Autowired
    private PhonebillConnector phonebillConnector;
    @Autowired
    private PhoneflowConnector phoneflowConnector;
    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;
    @Autowired
    private OrdersFasterLastSendService ordersFasterLastSendService;
    @Autowired
    private RemoteRetryOrdersFasterService remoteRetryOrdersFasterService;
    @Autowired
    private OrdersFasterSimpleService ordersFasterSimpleService;
    @Autowired
    private SupplierProductsService supplierProductsService;
    @Autowired
    private RemoteCenterConfigService remoteCenterConfigService;
    @Autowired
    private ObjectSupplier2 objectSupplier2;
    @Autowired
    private SupplierOrdersService supplierOrderDAO;
    @Autowired
    private AmbSubOrdersDao ambSubOrdersDAO;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;
    @Autowired
    private RemoteAppItemService remoteAppItemService;
    @Autowired
    private SupplierProductsDao supplierProductsDAO;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    public void onFinish(final Long orderId, final Long consumerId, final SupplierResponse resp) {
        this.flowworkEngine.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                block12: {
                    OrdersDto order = SupplierExchangeFlowWorker.this.orderReadManagerBo.find(orderId, consumerId);
                    SupplierExchangeFlowWorker.this.finallyDispatchEvent(order);
                    try {
                        OrdersDto o4u = new OrdersDto(orderId);
                        if (order.getSupplierOrderId() != null) {
                            SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
                            so4u.setSupplierBizId(resp.getSupplierBizId());
                            so4u.setSupplierInfo(resp.getBody());
                            if (resp.isSuccess()) {
                                so4u.setStatus("success");
                            }
                            if (resp.isFail()) {
                                so4u.setStatus("fail");
                            }
                            SupplierExchangeFlowWorker.this.supplierOrdersService.update(so4u);
                        }
                        if (resp.isFail()) {
                            o4u.setFailType(Integer.valueOf(1));
                        }
                        o4u.setError4Admin(resp.getError4Admin());
                        o4u.setError4Developer(resp.getError4Developer());
                        o4u.setError4Consumer(resp.getError4Consumer());
                        SupplierExchangeFlowWorker.this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, o4u.getFailType(), null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                        if (resp.isSuccess()) {
                            try {
                                SupplierExchangeFlowWorker.this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
                            }
                            catch (Exception e) {
                                log.error("flowworkStatusChangeService.markSupplierExchangeComplete  mainOrderID: " + orderId);
                                throw new Exception(e);
                            }
                            SupplierExchangeFlowWorker.this.flowworkEngine.go(orderId, consumerId);
                            break block12;
                        }
                        if (resp.isFail()) {
                            try {
                                SupplierExchangeFlowWorker.this.checkAndMake2fail(orderId, consumerId, order.getChargeMode(), order.getGmtCreate());
                                SupplierExchangeFlowWorker.this.flowworkEngine.go(orderId, consumerId);
                            }
                            catch (Exception e) {
                                log.error("checkAndMake2fail error", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("\u4e0a\u6e38\u8ba2\u5355\u5f02\u5e38\uff0c\u5f85\u4eba\u5de5\u786e\u8ba4\u95ee\u9898 orderId=" + order.getId(), (Throwable)e);
                        OrdersDto o4u = new OrdersDto(orderId);
                        o4u.setError4Admin("\u4e0a\u6e38\u5151\u6362\u5f02\u5e38:" + e.getMessage());
                        o4u.setError4Developer("\u5151\u6362\u5931\u8d25");
                        o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                        SupplierExchangeFlowWorker.this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                    }
                }
            }
        });
    }

    public void onException(final Long orderId, final Long consumerId, final Exception ex) {
        this.flowworkEngine.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                log.error("\u5411\u4e0a\u6e38\u5151\u6362\u5931\u8d25 orderId=" + orderId, (Throwable)ex);
                OrdersDto order = SupplierExchangeFlowWorker.this.orderReadManagerBo.find(orderId, consumerId);
                OrdersDto o4u = new OrdersDto(orderId);
                o4u.setFailType(Integer.valueOf(1));
                if (order.getSupplierOrderId() != null) {
                    SupplierOrderDto so = SupplierExchangeFlowWorker.this.supplierOrdersService.find(order.getSupplierOrderId());
                    String old = so.getSupplierInfo();
                    if (old == null) {
                        old = "";
                    }
                    so.setSupplierInfo(old + " submit exception:" + ex.getMessage());
                    SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
                    so4u.setSupplierInfo(so.getSupplierInfo());
                    SupplierExchangeFlowWorker.this.supplierOrdersService.update(so4u);
                }
                o4u.setError4Admin("\u4e0a\u6e38\u8fd4\u56de\u5f02\u5e38 " + ex.getMessage());
                o4u.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
                o4u.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                SupplierExchangeFlowWorker.this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, o4u.getFailType(), null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                SupplierExchangeFlowWorker.this.finallyDispatchEvent(order);
            }
        });
    }

    private void finallyDispatchEvent(OrdersDto order) {
        SupplierOrderDto so;
        if (order.getSupplierOrderId() != null && (so = this.supplierOrdersService.find(order.getSupplierOrderId())).getSendTime() != null) {
            order.setLastSendTime(new Date());
            this.ordersTextChangeService.updateLastSendTime(order.getId(), order.getConsumerId(), order.getLastSendTime());
            this.ordersFasterLastSendService.onLastSendTime(order);
            this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderLastSendTime, order));
        }
    }

    @Override
    public void asyncStart(Long orderId, Long consumerId, CompleteListener listener, ExecutorService es) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        this.flowworkStatusChangeService.changeAudit2SupplierExchange(orderId, consumerId);
        if ("qb".equals(order.getType())) {
            this.qbSupplierConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        } else if ("alipay".equals(order.getType())) {
            this.alipayOfficialSupplierConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        } else if ("coupon".equals(order.getType())) {
            this.couponConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        } else if ("object".equals(order.getType())) {
            this.objectConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        } else if ("virtual".equals(order.getType())) {
            this.virtualConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        } else if ("phonebill".equals(order.getType())) {
            this.phonebillConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        } else if ("phoneflow".equals(order.getType())) {
            this.phoneflowConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, listener), es);
        }
    }

    private void checkAndMake2fail(Long orderId, Long consumerId, String chargeMode, Date gmtCreate) throws Exception {
        this.checkCan2Fail(orderId, consumerId, chargeMode, gmtCreate);
        this.flowworkStatusChangeService.changeSupplierExchange2Fail(orderId, consumerId);
    }

    private void checkCan2Fail(Long orderId, Long consumerId, String chargeMode, Date gmtCreate) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        if (("alipay".equals(order.getType()) || "phonebill".equals(order.getType()) || "qb".equals(order.getType())) && ("turntable".equals(chargeMode) || "singlelottery".equals(chargeMode) || "hdtool".equals(chargeMode) || "game".equals(chargeMode) || "question".equals(chargeMode) || "quizz".equals(chargeMode) || "ngame".equals(chargeMode) || "guess".equals(chargeMode) || "activity".equals(chargeMode)) && new Date().getTime() - gmtCreate.getTime() < 2592000000L) {
            throw new Exception("\u62bd\u5956\u4ea7\u751f\u7684\u9886\u5956\u5f02\u5e38\u8ba2\u535530\u5929\u5185\u65e0\u6cd5\u4eba\u5de5\u5f3a\u5236\u5931\u8d25");
        }
    }

    public boolean callbackFromQbSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        SupplierData.SupplierOrderStatus status = this.qbSupplierConnector.callbackProcess(orderId, consumerId, request);
        if (status.isSuccess()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return true;
        }
        if (status.isFail()) {
            return false;
        }
        return false;
    }

    public boolean callbackFromPhonebillSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        SupplierData.SupplierOrderStatus status = this.phonebillConnector.callbackProcess(orderId, consumerId, request);
        if (status.isSuccess()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return true;
        }
        if (status.isFail()) {
            return false;
        }
        return false;
    }

    public boolean callbackFromPhoneflowSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        SupplierData.SupplierOrderStatus status = this.phoneflowConnector.callbackProcess(orderId, consumerId, request);
        if (status.isSuccess()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return true;
        }
        if (status.isFail()) {
            return false;
        }
        return false;
    }

    public boolean callbackProcessByDetail(Long orderId, Long consuemrId, AlipayOrderResponseDetail detail) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consuemrId);
        SupplierData.SupplierOrderStatus status = this.alipayOfficialSupplierConnector.callbackProcessByDetail(orderId, consuemrId, detail);
        if (status.isSuccess()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consuemrId);
            return true;
        }
        if (status.isFail()) {
            this.checkAndMake2fail(orderId, consuemrId, order.getChargeMode(), order.getGmtCreate());
            return true;
        }
        return false;
    }

    public boolean callbackFromVirtualSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        SupplierData.SupplierOrderStatus status = this.virtualConnector.callbackProcess(orderId, request);
        if (status.isSuccess()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return true;
        }
        if (status.isFail()) {
            this.checkAndMake2fail(orderId, consumerId, order.getChargeMode(), order.getGmtCreate());
            return true;
        }
        return false;
    }

    public void executeSend(Long orderId, Long consumerId, String expressName, String expressId) throws Exception {
        block9: {
            OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
            if (!"object".equals(order.getType())) {
                throw new Exception("\u975e\u5b9e\u7269\u8ba2\u5355\u65e0\u6cd5\u53d1\u8d27");
            }
            SupplierOrderDto so = this.supplierOrderDAO.find(order.getSupplierOrderId());
            if (so.getStatus().equals("to_deliver")) {
                try {
                    if (this.objectSupplier2.supplyExchangeObject(orderId, consumerId, expressName, expressId).booleanValue()) {
                        if (null != order.getConsumerPayPrice() && order.getConsumerPayPrice() > 0L) {
                            this.ordersStatusChangeBo.doAmbStatusAfterSend(order.getId(), order.getConsumerId());
                            this.ambSubOrdersDAO.updateShipStatus4Shiped(order.getSubOrderId());
                            this.ambOrderFastBo.createOrderFastWaitReceive(order.getId(), consumerId);
                            if (order.getSupplierOrderId() != null) {
                                SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
                                so4u.setStatus("success");
                                this.supplierOrdersService.update(so4u);
                            }
                            if (order.getItemId() != null) {
                                this.ordersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 4);
                            } else {
                                this.ordersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 5);
                            }
                        }
                        this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
                        return;
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.error("makeSuccess \u5904\u7406\u5931\u8d25", (Throwable)e);
                    throw new Exception("\u53d1\u8d27\u5931\u8d25", e);
                }
            }
            throw new Exception("\u72b6\u6001\u9519\u8bef\uff0c\u65e0\u6cd5\u6267\u884c");
        }
    }

    public void executeManualLotterySend(Long orderId, Long consumerId, String shipInfo) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (!"object".equals(order.getType())) {
            throw new Exception("\u975e\u5b9e\u7269\u8ba2\u5355\u65e0\u6cd5\u53d1\u8d27");
        }
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        if (so.getStatus().equals("to_deliver") && this.objectSupplier2.supplyExchangeManualLottery(orderId, consumerId, shipInfo).booleanValue()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return;
        }
        throw new Exception("\u72b6\u6001\u9519\u8bef\uff0c\u65e0\u6cd5\u6267\u884c");
    }

    public void executeCancel(Long orderId, Long consumerId, String reason) throws Exception {
        String myreason;
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (!"object".equals(order.getType())) {
            throw new Exception("\u975e\u5b9e\u7269\u8ba2\u5355\u65e0\u6cd5\u53d6\u6d88\u53d1\u8d27");
        }
        if ("turntable".equals(order.getChargeMode())) {
            throw new Exception("\u5927\u8f6c\u76d8\u4ea7\u751f\u7684\u8ba2\u5355\u65e0\u6cd5\u8fdb\u884c\u53d6\u6d88\u64cd\u4f5c");
        }
        if ("singlelottery".equals(order.getChargeMode())) {
            throw new Exception("\u5355\u54c1\u62bd\u5956\u4ea7\u751f\u7684\u8ba2\u5355\u65e0\u6cd5\u8fdb\u884c\u53d6\u6d88\u64cd\u4f5c");
        }
        if ("hdtool".equals(order.getChargeMode())) {
            throw new Exception("\u6d3b\u52a8\u5de5\u5177\u4ea7\u751f\u7684\u8ba2\u5355\u65e0\u6cd5\u8fdb\u884c\u53d6\u6d88\u64cd\u4f5c");
        }
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        AppItemDO appItem = this.remoteAppItemService.find(order.getAppItemId());
        if (appItem.getIsOwner().booleanValue() && so.getStatus().equals("to_deliver")) {
            so.setStatus("fail");
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus(so.getStatus());
            this.supplierOrdersService.update(so4u);
            myreason = "";
            if (reason != null && reason.length() > 0) {
                myreason = " \u7406\u7531\u662f\uff1a" + reason;
            }
        } else {
            throw new Exception("\u72b6\u6001\u9519\u8bef\uff0c\u65e0\u6cd5\u6267\u884c");
        }
        order.setError4Admin("\u5f00\u53d1\u8005\u53d6\u6d88\u8ba2\u5355" + myreason);
        order.setError4Consumer("\u8ba2\u5355\u53d6\u6d88\uff0c\u79ef\u5206\u8fd4\u8fd8" + myreason);
        order.setError4Developer("\u5f00\u53d1\u8005\u53d6\u6d88\u8ba2\u5355" + myreason);
        OrdersDto o4u = new OrdersDto(order.getId());
        o4u.setError4Admin(order.getError4Admin());
        o4u.setError4Consumer(order.getError4Consumer());
        o4u.setError4Developer(order.getError4Developer());
        this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
        this.checkAndMake2fail(orderId, consumerId, order.getChargeMode(), order.getGmtCreate());
    }

    public void adminCancel(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        this.checkAndMake2fail(orderId, consumerId, order.getChargeMode(), order.getGmtCreate());
    }

    public void virtualMakeComplete(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (!"virtual".equals(order.getType())) {
            throw new Exception("\u975e\u865a\u62df\u5546\u54c1");
        }
        this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
    }

    public void virtualMakeFail(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (!"virtual".equals(order.getType())) {
            throw new Exception("\u975e\u865a\u62df\u5546\u54c1");
        }
        this.checkAndMake2fail(orderId, consumerId, order.getChargeMode(), order.getGmtCreate());
    }

    public void mngForceSupplierFail(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        this.checkAndMake2fail(orderId, consumerId, order.getChargeMode(), order.getGmtCreate());
    }

    public void mngForceSupplierSuccess(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (order.getConsumerPayPrice() > 0L) {
            throw new Exception("\u52a0\u94b1\u8d2d\u4e0d\u53ef\u4ee5\u5f3a\u5236\u6210\u529f\uff01");
        }
        this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.SupplierExchange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void retryAlipayExchange(Long orderId, Long consumerId, boolean reInput, Map<String, Object> params) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        this.retryExchangeCheck(reInput, params);
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (!order.getType().equals("alipay")) throw new Exception("\u975e\u652f\u4ed8\u5b9d\u8ba2\u5355\uff0c\u65e0\u6cd5\u5904\u7406");
        String alipay = (String)params.get("alipay");
        String realname = (String)params.get("realname");
        if (reInput && (alipay == null || realname == null)) {
            throw new Exception("\u53c2\u6570\u4e0d\u5168");
        }
        if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus()) || !order.getAllowInputAgain().booleanValue()) throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
        SupplierProductEntity sp = this.supplierProductsDAO.findBySupplier("alipay-official");
        if (sp == null) {
            throw new RuntimeException("\u65e0AlipayOfficial\u4f9b\u5e94\u5546\u5f00\u542f");
        }
        if (reInput && !order.getAllowInputAgain().booleanValue()) {
            throw new RuntimeException("\u4e0d\u80fd\u91cd\u8bd5");
        }
        if (reInput) {
            AppDO app = this.remoteAppService.find(order.getAppId());
            order.setBizParams(this.generateBizParams(alipay, realname, "[" + app.getName() + "]\u652f\u4ed8\u5b9d\u8f6c\u8d26"));
            order.setBrief("\u652f\u4ed8\u5b9d\u53f7\uff1a" + alipay + "(" + realname + ") \u8f6c\u8d26\u5145\u503c\uff1a" + order.getFacePrice() / 100 + "\u5143");
        }
        SupplierOrderDto so = new SupplierOrderDto(true);
        so.setOrderId(order.getId());
        so.setStatus("create");
        so.setSupplierProductId(sp.getId());
        so.setBizParams(order.getBizParams());
        so.setDuibaOrderNum(so.generate());
        order.setSupplierOrderId(so.getId());
        order.setAllowInputAgain(Boolean.valueOf(false));
        boolean success = this.ordersStatusChangeBo.doUpdateAllowInputUsed(orderId, consumerId, so, order.getBizParams(), order.getBrief());
        if (!success) {
            throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
        }
        this.alipayOfficialSupplierConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, this.flowworkEngine.getGoingListener()), this.flowworkEngine.getExecutorService());
        this.remoteRetryOrdersFasterService.deleteByOrderId(order.getId());
    }

    public void retryObjectExchange(Long orderId, Long consumerId, boolean reInput, Map<String, Object> params) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        this.retryExchangeCheck(reInput, params);
        String addrName = (String)params.get("addrName");
        String addrProvince = (String)params.get("addrProvince");
        String addrCity = (String)params.get("addrCity");
        String addrArea = (String)params.get("addrArea");
        String addrDetail = (String)params.get("addrDetail");
        String addrPhone = (String)params.get("addrPhone");
        if (reInput && (addrName == null || addrProvince == null || addrDetail == null || addrPhone == null)) {
            throw new Exception("\u53c2\u6570\u4e0d\u5168");
        }
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (order.getStatus() != "success" && order.getStatus() != "fail" && order.getAllowInputAgain().booleanValue() && reInput && order.getAllowInputAgain().booleanValue()) {
            order.setBizParams(this.generateBizParams(addrName, addrPhone, addrProvince, addrCity, addrArea, addrDetail));
            SupplierOrderDto old = this.supplierOrdersService.find(order.getSupplierOrderId());
            SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
            supplierOrder.setOrderId(order.getId());
            supplierOrder.setStatus("to_deliver");
            supplierOrder.setSendTime(new Date());
            supplierOrder.setSupplierProductId(old.getSupplierProductId());
            supplierOrder.setBizParams(order.getBizParams());
            supplierOrder.setDuibaOrderNum(SupplierOrderDto.generate());
            boolean success = this.ordersStatusChangeBo.doUpdateAllowInputUsed4Object(orderId, consumerId, supplierOrder, order.getBizParams());
            if (!success) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            this.objectConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, this.flowworkEngine.getGoingListener()), this.flowworkEngine.getExecutorService());
        }
    }

    public void retryPhonebillExchange(Long orderId, Long consumerId, boolean reInput, Map<String, Object> params) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        this.retryExchangeCheck(reInput, params);
        String phone = (String)params.get("phone");
        String mobile = (String)params.get("mobile");
        String province = (String)params.get("province");
        if (reInput && (phone == null || mobile == null || province == null)) {
            throw new Exception("\u53c2\u6570\u4e0d\u5168");
        }
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        SupplierProductDto sp = this.queryProduct(mobile, province, order.getFacePrice());
        if (sp == null) {
            throw new Exception("\u6b64\u53f7\u7801\u6682\u4e0d\u652f\u6301\u5145\u503c");
        }
        if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus()) && order.getAllowInputAgain().booleanValue()) {
            Boolean go = this.phonebillConnector.createSupplierOrder(order, sp, reInput, phone, mobile, province);
            if (!go.booleanValue()) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        } else {
            throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
        }
        this.phonebillConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, this.flowworkEngine.getGoingListener()), this.flowworkEngine.getExecutorService());
        this.remoteRetryOrdersFasterService.deleteByOrderId(order.getId());
    }

    public void retryQbExchange(Long orderId, Long consumerId, boolean reInput, Map<String, Object> params) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        this.retryExchangeCheck(reInput, params);
        String qq = (String)params.get("qq");
        if (reInput && qq == null) {
            throw new Exception("\u53c2\u6570\u4e0d\u5168");
        }
        OrdersDto order = this.checkStayAtMyNode(orderId, consumerId);
        if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus()) && order.getAllowInputAgain().booleanValue()) {
            CenterConfigDO goukaSwitch;
            CenterConfigDO enlianSwitch;
            CenterConfigDO tencentSwitch;
            if (reInput && !order.getAllowInputAgain().booleanValue()) {
                return;
            }
            SupplierOrderDto so4i = new SupplierOrderDto(true);
            so4i.setOrderId(orderId);
            so4i.setStatus("create");
            SupplierProductEntity sp = null;
            if (sp == null && (tencentSwitch = this.remoteCenterConfigService.findByType("tencent-qb-switch")).getBoolValue() != null && tencentSwitch.getBoolValue().booleanValue()) {
                sp = this.supplierProductsDAO.findBySupplier("qb-tencent");
            }
            if (sp == null && (enlianSwitch = this.remoteCenterConfigService.findByType("enlian-qb-switch")).getBoolValue() != null && enlianSwitch.getBoolValue().booleanValue()) {
                sp = this.supplierProductsDAO.findBySupplier("qb-enlian");
            }
            if (sp == null && (goukaSwitch = this.remoteCenterConfigService.findByType("gouka-qb-switch")).getBoolValue() != null && goukaSwitch.getBoolValue().booleanValue()) {
                sp = this.supplierProductsDAO.findBySupplier("qb-gouka");
            }
            if (sp == null) {
                throw new RuntimeException("\u65e0QB\u4f9b\u5e94\u5546\u5f00\u542f");
            }
            so4i.setSupplierProductId(sp.getId());
            so4i.setBizParams(qq);
            so4i.setDuibaOrderNum(SupplierOrderDto.generate());
            boolean success = this.ordersStatusChangeBo.doUpdateAllowInputUsed(order.getId(), order.getConsumerId(), so4i, qq, "QQ\u53f7\uff1a" + qq + " \u5145\u503c" + order.getQuantity() + " Q\u5e01");
            if (!success) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        } else {
            throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
        }
        this.qbSupplierConnector.asyncSupplierExchange(orderId, consumerId, new CustomSupplierCallback(orderId, consumerId, this.flowworkEngine.getGoingListener()), this.flowworkEngine.getExecutorService());
        this.remoteRetryOrdersFasterService.deleteByOrderId(order.getId());
    }

    public SupplierProductDto queryProduct(String mobile, String province, int facePrice) {
        CenterConfigDO lianlianConfig = this.remoteCenterConfigService.findByType("lianlian-phonebill-switch");
        if (!(facePrice < 1000 || lianlianConfig != null && lianlianConfig.getBoolValue().booleanValue())) {
            return null;
        }
        List<Object> ps = new ArrayList();
        if (facePrice < 1000) {
            if (mobile.contains("\u7535\u4fe1")) {
                CenterConfigDO oufeiConfig = this.remoteCenterConfigService.findByType("oufei-phonebill-switch");
                if (oufeiConfig == null || !oufeiConfig.getBoolValue().booleanValue()) {
                    return null;
                }
                ps = this.supplierProductsService.findBySupplierAndFacePrice("phonebill-oufei", facePrice);
            } else {
                CenterConfigDO sududaConfig = this.remoteCenterConfigService.findByType("sududa-phonebill-switch");
                if (sududaConfig == null || !sududaConfig.getBoolValue().booleanValue()) {
                    return null;
                }
                ps = this.supplierProductsService.findBySupplierAndFacePrice("phonebill-sududa", facePrice);
            }
        } else {
            ps = this.supplierProductsService.findBySupplierAndFacePrice("phonebill-lianlian-new-platform", facePrice);
        }
        for (SupplierProductDto supplierProductDto : ps) {
            if (mobile.contains(supplierProductDto.getMobile()) && province.contains(supplierProductDto.getProvince()) && facePrice == supplierProductDto.getFacePrice()) {
                return supplierProductDto;
            }
            if (!mobile.contains(supplierProductDto.getMobile()) || facePrice != supplierProductDto.getFacePrice() || !supplierProductDto.getProvince().contains("\u5168\u56fd")) continue;
            return supplierProductDto;
        }
        return null;
    }

    private void retryExchangeCheck(boolean reInput, Map<String, Object> params) throws Exception {
        if (!TakeOrderSwitch.get().isEnable()) {
            throw new StatusException(17);
        }
    }

    public boolean fixStatusBySupplierQuery(Long orderId, Long consumerId) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        SupplierData.SupplierOrderStatus status = this.phonebillConnector.fixStatusBySupplierQuery(orderId, consumerId);
        if (status.isSuccess()) {
            this.flowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return true;
        }
        return false;
    }

    public String generateBizParams(String alipay, String realname, String memo) {
        return alipay + ":" + realname + ":" + memo;
    }

    public String generateBizParams(String addrName, String addrPhone, String addrProvince, String addrCity, String addrArea, String addrDetail) {
        return addrName + ":" + addrPhone + ":" + addrProvince + ":" + addrCity + ":" + (addrArea == null ? "" : addrArea) + ":" + addrDetail;
    }

    private class CustomSupplierCallback
    implements Supplier.SupplierCallback {
        private Long orderId;
        private Long consumerId;
        private CompleteListener listener;

        public CustomSupplierCallback(Long orderId, Long consumerId, CompleteListener listener) {
            this.orderId = orderId;
            this.consumerId = consumerId;
            this.listener = listener;
        }

        @Override
        public void onFinish(SupplierData.SupplierExchangeResponse resp) {
            block12: {
                this.finallyDispatchEvent();
                OrdersDto order = SupplierExchangeFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
                try {
                    OrdersDto o4u = new OrdersDto(this.orderId);
                    if (order.getSupplierOrderId() != null) {
                        SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
                        so4u.setSupplierBizId(resp.getSupplierBizId());
                        so4u.setSupplierInfo(resp.getSupplierBody());
                        if (resp.isSuccess()) {
                            so4u.setStatus("success");
                        }
                        if (resp.isFail()) {
                            so4u.setStatus("fail");
                        }
                        SupplierExchangeFlowWorker.this.supplierOrdersService.update(so4u);
                    }
                    if (resp.isFail()) {
                        o4u.setFailType(Integer.valueOf(1));
                    }
                    o4u.setError4Admin(resp.getError4Admin());
                    o4u.setError4Developer(resp.getError4Developer());
                    o4u.setError4Consumer(resp.getError4Consumer());
                    SupplierExchangeFlowWorker.this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), this.consumerId, o4u.getFailType(), null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                    if (resp.isSuccess()) {
                        try {
                            SupplierExchangeFlowWorker.this.flowworkStatusChangeService.markSupplierExchangeComplete(this.orderId, this.consumerId);
                        }
                        catch (Exception e) {
                            log.error("flowworkStatusChangeService.markSupplierExchangeComplete  mainOrderID: " + this.orderId);
                            throw new Exception(e);
                        }
                        this.listener.onComplete(this.orderId, this.consumerId);
                        break block12;
                    }
                    if (resp.isFail()) {
                        try {
                            SupplierExchangeFlowWorker.this.checkAndMake2fail(this.orderId, this.consumerId, order.getChargeMode(), order.getGmtCreate());
                            this.listener.onComplete(this.orderId, this.consumerId);
                        }
                        catch (Exception e) {
                            log.error("checkAndMake2fail error", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u4e0a\u6e38\u8ba2\u5355\u5f02\u5e38\uff0c\u5f85\u4eba\u5de5\u786e\u8ba4\u95ee\u9898 orderId=" + order.getId(), (Throwable)e);
                    OrdersDto o4u = new OrdersDto(this.orderId);
                    o4u.setError4Admin("\u4e0a\u6e38\u5151\u6362\u5f02\u5e38:" + e.getMessage());
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    SupplierExchangeFlowWorker.this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), this.consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                }
            }
        }

        @Override
        public void onException(Exception e1) {
            log.error("\u5411\u4e0a\u6e38\u5151\u6362\u5931\u8d25 orderId=" + this.orderId, (Throwable)e1);
            OrdersDto order = SupplierExchangeFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
            OrdersDto o4u = new OrdersDto(this.orderId);
            o4u.setFailType(Integer.valueOf(1));
            if (order.getSupplierOrderId() != null) {
                SupplierOrderDto so = SupplierExchangeFlowWorker.this.supplierOrdersService.find(order.getSupplierOrderId());
                String old = so.getSupplierInfo();
                if (old == null) {
                    old = "";
                }
                so.setSupplierInfo(old + " submit exception:" + e1.getMessage());
                SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
                so4u.setSupplierInfo(so.getSupplierInfo());
                SupplierExchangeFlowWorker.this.supplierOrdersService.update(so4u);
            }
            o4u.setError4Admin("\u4e0a\u6e38\u8fd4\u56de\u5f02\u5e38 " + e1.getMessage());
            o4u.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
            o4u.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            SupplierExchangeFlowWorker.this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), this.consumerId, o4u.getFailType(), null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
            this.finallyDispatchEvent();
        }

        private void finallyDispatchEvent() {
            SupplierOrderDto so;
            OrdersDto order = SupplierExchangeFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
            OrdersDto o4u = new OrdersDto(this.orderId);
            if (order.getSupplierOrderId() != null && (so = SupplierExchangeFlowWorker.this.supplierOrdersService.find(order.getSupplierOrderId())).getSendTime() != null) {
                o4u.setLastSendTime(new Date());
                SupplierExchangeFlowWorker.this.ordersTextChangeService.updateLastSendTime(o4u.getId(), this.consumerId, o4u.getLastSendTime());
                OrdersDto orderNew = SupplierExchangeFlowWorker.this.orderReadManagerBo.find(this.orderId, this.consumerId);
                SupplierExchangeFlowWorker.this.ordersFasterLastSendService.onLastSendTime(orderNew);
                SupplierExchangeFlowWorker.this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderLastSendTime, orderNew));
            }
        }
    }
}

