/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier;

import cn.com.duiba.order.center.api.dto.flowwork.AlipayOrderResponseDetail;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.AlipayOfficialSupplier2;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.SupplierConnector;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import cn.com.duiba.order.center.biz.tool.AlipayUtil;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlipayOfficialSupplierConnector
extends SupplierConnector {
    private static Logger log = LoggerFactory.getLogger(AlipayOfficialSupplierConnector.class);
    public static final String ACCOUNT = "alipay";
    public static final String REALNAME = "realname";
    @Autowired
    private AlipayOfficialSupplier2 alipayOfficialSupplier2;
    @Autowired
    private SupplierProductsService supplierProductsService;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;

    @Override
    public void asyncSupplierExchange(Long orderId, Long consumerId, Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        String[] sp = order.getBizParams().split(":");
        AlipayOfficialSupplier2.AlipayOfficialRequest req = AlipayOfficialSupplier2.buildRequestData(so.getDuibaOrderNum(), sp[0], sp[1], order.getFacePrice() / 100, sp[2]);
        this.alipayOfficialSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
    }

    public SupplierData.SupplierOrderStatus callbackProcessByDetail(Long orderId, Long consumerId, AlipayOrderResponseDetail detail) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("alipay-official".equals(sp.getSupplier()) && "send".equals(so.getStatus())) {
            if (detail.isSuccess()) {
                SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
                so4u.setStatus("success");
                this.supplierOrdersService.update(so4u);
                BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
                status.setSuccess(true);
                return status;
            }
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus("fail");
            so4u.setErrorMessage(detail.getReason());
            this.supplierOrdersService.update(so4u);
            OrdersDto o4u = new OrdersDto(orderId);
            o4u.setError4Admin(AlipayUtil.errorCodeMapping(detail.getReason()));
            o4u.setError4Developer(AlipayUtil.errorCodeMapping4Dev(detail.getReason()));
            o4u.setError4Consumer(AlipayUtil.errorCodeMapping4Dev(detail.getReason()));
            this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
            BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
            status.setFail(true);
            return status;
        }
        log.error("\u8ba2\u5355\u72b6\u6001\u5df2\u7ecf\u5904\u7406\uff0c\u65e0\u6cd5\u518d\u6b21\u5904\u7406\uff0corderId=" + order.getId() + " orderNum=" + order.getOrderNum());
        return new BaseSupplierOrderStatus();
    }
}

