/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.OrdersStatusChangeBo;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.GyjxPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.LianLianPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.NewLianLianPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.OufeiPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.SududaPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.SupplierConnector;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierOrdersService;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhonebillConnector
extends SupplierConnector {
    private static Logger log = LoggerFactory.getLogger(PhonebillConnector.class);
    public static final String PHONE = "phone";
    public static final String MOBILE = "mobile";
    public static final String PROVINCE = "province";
    @Autowired
    private SupplierProductsService supplierProductsService;
    @Autowired
    private GyjxPhonebillSupplier2 gyjxPhonebillSupplier2;
    @Autowired
    private SududaPhonebillSupplier2 sududaPhonebillSupplier2;
    @Autowired
    private LianLianPhonebillSupplier2 lianLianPhonebillSupplier2;
    @Autowired
    private OufeiPhonebillSupplier2 oufeiPhonebillSupplier2;
    @Autowired
    protected OrdersStatusChangeBo ordersStatusChangeBo;
    @Autowired
    private NewLianLianPhonebillSupplier2 newlianLianPhonebillSupplier2;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    private SupplierOrdersService supplierOrdersService;

    @Override
    public void asyncSupplierExchange(Long orderId, Long consumerId, Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phonebill-gyjx".equals(sp.getSupplier())) {
            SupplierData.SupplierExchangeRequest req = GyjxPhonebillSupplier2.buildRequestData(sp, so.getDuibaOrderNum());
            this.gyjxPhonebillSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        } else if ("phonebill-sududa".equals(sp.getSupplier())) {
            SupplierData.SupplierExchangeRequest req = SududaPhonebillSupplier2.buildRequest(sp, so.getDuibaOrderNum());
            this.sududaPhonebillSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        } else if ("phonebill-oufei".equals(sp.getSupplier())) {
            SupplierData.SupplierExchangeRequest req = OufeiPhonebillSupplier2.buildRequestData(sp, so.getDuibaOrderNum());
            this.oufeiPhonebillSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        } else if ("phonebill-lianlian-new".equals(sp.getSupplier())) {
            SupplierData.SupplierExchangeRequest req = LianLianPhonebillSupplier2.buildRequestData(sp, so.getDuibaOrderNum());
            this.lianLianPhonebillSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        } else if ("phonebill-lianlian-new-platform".equals(sp.getSupplier())) {
            SupplierData.SupplierExchangeRequest req = NewLianLianPhonebillSupplier2.buildRequestData(sp, so.getDuibaOrderNum());
            this.newlianLianPhonebillSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        }
    }

    public SupplierData.SupplierOrderStatus callbackProcess(Long orderId, Long consumerId, HttpServletRequest request) throws Exception {
        SupplierData.SupplierOrderStatus status = null;
        String orderNum = null;
        if ("gyjx".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.gyjxPhonebillSupplier2.callbackParse(request);
            orderNum = request.getParameter("orderid");
        } else if ("sududa".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.sududaPhonebillSupplier2.callbackParse(request);
            orderNum = request.getParameter("orderNum");
        } else if ("oufei".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.oufeiPhonebillSupplier2.callbackParse(request);
            orderNum = request.getParameter("sporder_id");
        } else if ("lianlian".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.lianLianPhonebillSupplier2.callbackParse(request);
            orderNum = request.getParameter("partnerStreamNumber");
        } else if ("newlianlian".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.newlianLianPhonebillSupplier2.callbackParse(request);
            orderNum = request.getParameter("partnerStreamNumber");
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        if (!this.isMatchSupplierOrder(orderId, consumerId, orderNum)) {
            throw new Exception("\u8ba2\u5355\u53f7\u4e0e\u4e3b\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        so.setSupplierInfo(PhonebillConnector.converParams2String(request.getParameterMap()));
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setSupplierInfo(so.getSupplierInfo());
        this.supplierOrdersService.update(so4u);
        if (status.isSuccess()) {
            return status;
        }
        if (status.isFail()) {
            OrdersDto o4u = new OrdersDto(orderId);
            o4u.setError4Admin("\u5361\u5355:\u4e0a\u6e38\u901a\u77e5\u5931\u8d25");
            o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            o4u.setError4Developer("\u4e0a\u6e38\u5151\u6362\u5931\u8d25");
            this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
            return status;
        }
        if (status.isProcessing() || status.isNotExist()) {
            // empty if block
        }
        return status;
    }

    public static String converParams2String(Map<String, String[]> params) {
        StringBuffer sb = new StringBuffer();
        try {
            for (String key : params.keySet()) {
                sb.append(key).append("=");
                String[] values = params.get(key);
                if (values != null) {
                    for (String s : values) {
                        sb.append(s).append(",");
                    }
                }
                sb.append(";");
            }
        }
        catch (Exception e) {
            log.error("converParams2String error", (Throwable)e);
        }
        return sb.toString();
    }

    public Boolean createSupplierOrder(OrdersDto order, SupplierProductDto sp, boolean reInput, String phone, String mobile, String province) {
        try {
            if (reInput && !order.getAllowInputAgain().booleanValue()) {
                return false;
            }
            if (reInput) {
                order.setBizParams(phone + ":" + mobile + ":" + province);
                order.setBrief("\u624b\u673a\u53f7:" + phone + " \u5145\u503c" + order.getQuantity() + "\u5143");
            }
            SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
            supplierOrder.setOrderId(order.getId());
            supplierOrder.setStatus("create");
            supplierOrder.setSupplierProductId(sp.getId());
            supplierOrder.setBizParams(order.getBizParams());
            supplierOrder.setDuibaOrderNum(SupplierOrderDto.generate());
            order.setAllowInputAgain(Boolean.valueOf(false));
            boolean success = this.ordersStatusChangeBo.doUpdateAllowInputUsed(order.getId(), order.getConsumerId(), supplierOrder, order.getBizParams(), order.getBrief());
            if (!success) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public SupplierData.SupplierOrderStatus fixStatusBySupplierQuery(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (sp.getSupplier().equals("phonebill-gyjx")) {
            SupplierData.SupplierOrderStatus status = this.gyjxPhonebillSupplier2.queryOrderStatus(so.getDuibaOrderNum(), so.getSupplierBizId());
            if (!status.isSuccess()) {
                if (status.isFail()) {
                    OrdersDto o4u = new OrdersDto(orderId);
                    o4u.setError4Admin("\u5361\u5355\uff1a\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                } else if (status.isProcessing() || status.isNotExist()) {
                    // empty if block
                }
            }
            return status;
        }
        if (sp.getSupplier().equals("phonebill-sududa")) {
            SupplierData.SupplierOrderStatus status = this.sududaPhonebillSupplier2.queryOrderStatus(so.getDuibaOrderNum(), so.getSupplierBizId());
            if (!status.isSuccess()) {
                if (status.isFail()) {
                    if (StringUtils.isBlank((String)order.getError4Admin())) {
                        OrdersDto o4u = new OrdersDto(orderId);
                        o4u.setError4Admin("\u5361\u5355\uff1a\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                        o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                        o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                        this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                    }
                } else if (status.isProcessing() || status.isNotExist()) {
                    // empty if block
                }
            }
            return status;
        }
        if (sp.getSupplier().equals("phonebill-oufei")) {
            SupplierData.SupplierOrderStatus status = this.oufeiPhonebillSupplier2.queryOrderStatus(so.getDuibaOrderNum(), so.getSupplierBizId());
            if (!status.isSuccess()) {
                if (status.isFail()) {
                    OrdersDto o4u = new OrdersDto(orderId);
                    o4u.setError4Admin("\u5361\u5355\uff1a\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                } else if (status.isProcessing() || status.isNotExist()) {
                    // empty if block
                }
            }
            return status;
        }
        if (sp.getSupplier().equals("phonebill-lianlian-new")) {
            SupplierData.SupplierOrderStatus status = this.lianLianPhonebillSupplier2.queryOrderStatus(so.getDuibaOrderNum(), so.getSupplierBizId());
            if (!status.isSuccess()) {
                if (status.isFail()) {
                    OrdersDto o4u = new OrdersDto(orderId);
                    o4u.setError4Admin("\u5361\u5355\uff1a\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                } else if (status.isProcessing() || status.isNotExist()) {
                    // empty if block
                }
            }
            return status;
        }
        if (sp.getSupplier().equals("phonebill-lianlian-new-platform")) {
            SupplierData.SupplierOrderStatus status = this.newlianLianPhonebillSupplier2.queryOrderStatus(so.getDuibaOrderNum(), so.getSupplierBizId());
            if (!status.isSuccess()) {
                if (status.isFail()) {
                    OrdersDto o4u = new OrdersDto(orderId);
                    o4u.setError4Admin("\u5361\u5355\uff1a\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, null, o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                } else if (status.isProcessing() || status.isNotExist()) {
                    // empty if block
                }
            }
            return status;
        }
        return null;
    }
}

