/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.mirror;

import cn.com.duiba.order.center.api.dto.orders.OrderSyncMessage;
import cn.com.duiba.order.center.biz.service.orders.mirror.OrdersMirrorSyncService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrdersSyncFixThread
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(OrdersSyncFixThread.class);
    private static ScheduledExecutorService es = Executors.newScheduledThreadPool(1);
    private static ConcurrentLinkedQueue<OrderSyncMessage> queue = new ConcurrentLinkedQueue();
    @Autowired
    private OrdersMirrorSyncService ordersMirrorSyncService;

    public void afterPropertiesSet() throws Exception {
        es.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                while (!queue.isEmpty()) {
                    OrderSyncMessage msg = (OrderSyncMessage)queue.poll();
                    boolean success = OrdersSyncFixThread.this.ordersMirrorSyncService.syncByOrderId(msg.getOrderId(), msg.getConsumerId());
                    if (!success) {
                        log.error("orderId=" + msg.getOrderId() + " sync fail");
                        continue;
                    }
                    log.error("orderId=" + msg.getOrderId() + " sync success");
                }
            }
        }, 3000L, 100L, TimeUnit.MILLISECONDS);
    }

    public void addNeetSyncOrder(Long orderId, Long consumerId) {
        log.error("orderId=" + orderId + " add queue");
        OrderSyncMessage msg = new OrderSyncMessage();
        msg.setOrderId(orderId);
        msg.setConsumerId(consumerId);
        queue.offer(msg);
    }
}

