/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.seckill.impl;

import cn.com.duiba.order.center.api.dto.seckill.TakeOrderQueueDto;
import cn.com.duiba.order.center.api.dto.seckill.TakeOrderQueueRecordDto;
import cn.com.duiba.order.center.biz.dao.queue.TakeOrderQueueDao;
import cn.com.duiba.order.center.biz.dao.queue.TakeOrderQueueRecordDao;
import cn.com.duiba.order.center.biz.entity.queue.TakeOrderQueueEntity;
import cn.com.duiba.order.center.biz.entity.queue.TakeOrderQueueRecordEntity;
import cn.com.duiba.order.center.biz.service.seckill.TakeOrderQueueService;
import cn.com.duiba.order.center.biz.tool.MD5;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="takeOrderQueueService")
public class TakeOrderQueueServiceImpl
implements TakeOrderQueueService {
    private static Logger log = LoggerFactory.getLogger(TakeOrderQueueServiceImpl.class);
    @Autowired
    private TakeOrderQueueDao takeOrderQueueDAO;
    @Autowired
    private TakeOrderQueueRecordDao takeOrderQueueRecordDAO;
    @Resource
    private PlatformTransactionManager creditsMasterTransactionManager;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public TakeOrderQueueDto insertQueue(TakeOrderQueueDto queue) throws Exception {
        TakeOrderQueueEntity entity = (TakeOrderQueueEntity)BeanUtils.copy((Object)queue, TakeOrderQueueEntity.class);
        TakeOrderQueueEntity ret = this.takeOrderQueueDAO.insert(entity);
        this.cacheClient.remove(this.getMemcachedKey(queue.getBatchId()));
        return (TakeOrderQueueDto)BeanUtils.copy((Object)ret, TakeOrderQueueDto.class);
    }

    @Override
    public TakeOrderQueueRecordDto insertRecord(TakeOrderQueueRecordDto record) throws Exception {
        TakeOrderQueueRecordEntity entity = (TakeOrderQueueRecordEntity)BeanUtils.copy((Object)record, TakeOrderQueueRecordEntity.class);
        this.takeOrderQueueRecordDAO.insert(entity);
        record.setId(entity.getId());
        return record;
    }

    @Override
    public TakeOrderQueueRecordDto findRecordByQueueId(Long queueId) {
        return (TakeOrderQueueRecordDto)BeanUtils.copy((Object)this.takeOrderQueueRecordDAO.findByQueueId(queueId), TakeOrderQueueRecordDto.class);
    }

    @Override
    public TakeOrderQueueDto findQueue(Long id) {
        return (TakeOrderQueueDto)BeanUtils.copy((Object)this.takeOrderQueueDAO.find(id), TakeOrderQueueDto.class);
    }

    @Override
    public int countQueueSize(String batchId) {
        Integer count = (Integer)this.cacheClient.get(this.getMemcachedKey(batchId));
        if (count == null) {
            count = this.takeOrderQueueDAO.countByBatchId(batchId);
            this.cacheClient.set(this.getMemcachedKey(batchId), (Object)count, 60);
        }
        return count;
    }

    private String getMemcachedKey(String batchId) {
        return "132-" + batchId;
    }

    private String getMemcacheTakingOrderKey(Long queueId) {
        return "132-" + queueId;
    }

    @Override
    public List<TakeOrderQueueDto> poll(int count) throws Exception {
        TransactionStatus status = this.creditsMasterTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        List qList = null;
        try {
            qList = BeanUtils.copyList(this.takeOrderQueueDAO.findTopQueues4Update(count), TakeOrderQueueDto.class);
            if (qList != null) {
                for (TakeOrderQueueDto t : qList) {
                    this.takeOrderQueueDAO.delete(t.getId());
                }
            }
        }
        catch (Exception e) {
            status.setRollbackOnly();
            log.error("SecondKillQueueScanManager scan error", (Throwable)e);
            throw e;
        }
        finally {
            this.creditsMasterTransactionManager.commit(status);
        }
        if (qList != null) {
            for (TakeOrderQueueDto t : qList) {
                this.cacheClient.remove(this.getMemcachedKey(t.getBatchId()));
                this.cacheClient.set(this.getMemcacheTakingOrderKey(t.getId()), (Object)"1", 20);
            }
        }
        return qList;
    }

    @Override
    public int checkTakeOrderSuccess(Long queueId) {
        TakeOrderQueueDto queue = this.findQueue(queueId);
        if (queue != null) {
            return 2;
        }
        TakeOrderQueueRecordDto record = this.findRecordByQueueId(queueId);
        if (record != null) {
            return 1;
        }
        String value = (String)this.cacheClient.get(this.getMemcacheTakingOrderKey(queueId));
        if (value != null) {
            return 2;
        }
        return 0;
    }

    @Override
    public String generateBatchId(ItemKey itemKey) {
        String batchId = null;
        if (TakeOrderQueueDto.isSecondKill((ItemKey)itemKey)) {
            if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(0) && itemKey.getItem().isOpTypeItem(1)) {
                String value = "item-" + itemKey.getItem().getId() + "-" + itemKey.getItem().getLimitTimeBetween() + "-" + itemKey.getItem().getLimitEverydayQuantity();
                try {
                    batchId = MD5.md5(value);
                }
                catch (Exception e) {
                    log.error("MD5.md5 error", (Throwable)e);
                }
            } else if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(0) && itemKey.getAppItem().isOpTypeAppItem(1)) {
                String value = "appItem-" + itemKey.getAppItem().getId() + "-" + itemKey.getAppItem().getLimitTimeBetween() + "-" + itemKey.getAppItem().getLimitEverydayQuantity();
                try {
                    batchId = MD5.md5(value);
                }
                catch (Exception e) {
                    log.error("MD5.md5 error", (Throwable)e);
                }
            }
        }
        return batchId;
    }
}

