/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.tool;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;

public final class AESUtils {
    private static final byte[] INIT_VECTOR = new byte[]{49, 55, 54, 53, 52, 51, 50, 49, 56, 39, 54, 53, 51, 35, 50, 51};

    public static String encrypt(String content, String apiKey) throws Exception {
        if (apiKey == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        String encrypted = null;
        byte[] keyBytes = apiKey.getBytes();
        if (keyBytes.length != 32 && keyBytes.length != 24 && keyBytes.length != 16) {
            throw new IllegalArgumentException("Key length must be 128/192/256 bits!");
        }
        byte[] encryptedBytes = null;
        encryptedBytes = AESUtils.encrypt(content.getBytes(), keyBytes, INIT_VECTOR);
        encrypted = new String(Hex.encode((byte[])encryptedBytes));
        return encrypted;
    }

    public static String decrypt(String content, String apiKey) throws Exception {
        if (apiKey == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        String decrypted = null;
        byte[] encryptedContent = Hex.decode((String)content);
        byte[] keyBytes = apiKey.getBytes();
        byte[] decryptedBytes = null;
        if (keyBytes.length != 32 && keyBytes.length != 24 && keyBytes.length != 16) {
            throw new IllegalArgumentException("Key length must be 128/192/256 bits!");
        }
        decryptedBytes = AESUtils.decrypt(encryptedContent, keyBytes, INIT_VECTOR);
        decrypted = new String(decryptedBytes);
        return decrypted;
    }

    private static byte[] encrypt(byte[] plain, byte[] key, byte[] iv) throws Exception {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        aes.init(true, (CipherParameters)ivAndKey);
        return AESUtils.cipherData(aes, plain);
    }

    private static byte[] decrypt(byte[] cipher, byte[] key, byte[] iv) throws Exception {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        aes.init(false, (CipherParameters)ivAndKey);
        return AESUtils.cipherData(aes, cipher);
    }

    private static byte[] cipherData(PaddedBufferedBlockCipher cipher, byte[] data) throws Exception {
        int minSize = cipher.getOutputSize(data.length);
        byte[] outBuf = new byte[minSize];
        int length1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int length2 = cipher.doFinal(outBuf, length1);
        int actualLength = length1 + length2;
        byte[] result = new byte[actualLength];
        System.arraycopy(outBuf, 0, result, 0, result.length);
        return result;
    }

    public static void main(String[] args) {
        try {
            String apiKey = "DkW5saY2PSQoplUiH2YmiXfMAKUJtzwU";
            String content = "test12345";
            long start = System.currentTimeMillis();
            String encrypt = AESUtils.encrypt(content, apiKey);
            System.out.println(System.currentTimeMillis() - start + " ms");
            System.out.println(encrypt);
            String decrypt = AESUtils.decrypt(encrypt, apiKey);
            System.out.println(decrypt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

