package cn.com.duiba.order.center.biz.dao.orderconsumer;


import org.apache.ibatis.annotations.Param;

/**
 * 主订单流程节点变更操作类
 * <p>
 * 此类只能提供给 XXWorker 调用
 * 其他类不得引用此类，进行调用！！！
 *
 * @author xuhengfei
 */
public interface FlowworkStatusChangeDao {

    //等扣费节点完成，删除此方法
    //public int changeCreate2ConsumeCredits(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    //扣费节点新增方法
    public int changeCreate2DeveloperPay(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    //扣费节点新增方法
    public int changeDeveloperPay2DuibaPay(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    //扣费节点新增方法
    public int changeDuibaPay2ConsumeCredits(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeConsumeCredits2ConsumerPay(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeConsumerPay2Audit(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeAudit2SupplierExchange(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeSupplierExchange2AfterSend(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeAfterSend2Success(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeCreate2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeConsumeCredits2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeConsumerPay2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeCreate2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, String error4consumer, @Param("tableName") String tableName);

    public int changeAfterSend2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeDuibaPay2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeDeveloperPay2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeAudit2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeSupplierExchange2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markCreateComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 从started -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markDeveloperPayComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int markDuibaPayComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markConsumeCreditsComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markConsumerPayComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markAuditComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markSupplierExchangeComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markAfterSendComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markSuccessComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @
     */
    public int markFailComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 兼容处理老订单
     * 由于老订单的flowwork_stage = null
     * 这里需要将正确的flowwork_stage设置进去
     *
     * @
     */
    public int compatibleOldOrderStatus(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("nodeTypeKey")String nodeTypeKey, @Param("tableName") String tableName);//TODO nodetype


    public int changeCreate2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeAfterSend2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeConsumeCredits2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeConsumerPay2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeAudit2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeSupplierExchange2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeDeveloperPay2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    public int changeDuibaPay2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);


}
