package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.FlowworkStatusChangeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/21.
 */
@Service
public class MainOrderFlowworkStatusChangeHandle {

    @Autowired
    private FlowworkStatusChangeDao flowworkStatusChangeDao;

    //扣费节点新增方法
    public int changeCreate2DeveloperPay(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeCreate2DeveloperPay(orderId,consumerId,tableName);
    }


    //扣费节点新增方法
    public int changeDeveloperPay2DuibaPay(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeDeveloperPay2DuibaPay(orderId,consumerId,tableName);
    }


    //扣费节点新增方法
    public int changeDuibaPay2ConsumeCredits(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeDuibaPay2ConsumeCredits(orderId,consumerId,tableName);
    }


    public int changeConsumeCredits2ConsumerPay(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeConsumeCredits2ConsumerPay(orderId,consumerId,tableName);
    }


    public int changeConsumerPay2Audit(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeConsumerPay2Audit(orderId,consumerId,tableName);
    }


    public int changeAudit2SupplierExchange(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeAudit2SupplierExchange(orderId,consumerId,tableName);
    }


    public int changeSupplierExchange2AfterSend(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeSupplierExchange2AfterSend(orderId,consumerId,tableName);
    }


    public int changeAfterSend2Success(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeAfterSend2Success(orderId,consumerId,tableName);
    }


    public int changeCreate2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeCreate2Fail(orderId,consumerId,tableName);
    }


    public int changeConsumeCredits2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeConsumeCredits2Fail(orderId,consumerId,tableName);
    }


    public int changeConsumerPay2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeConsumerPay2Fail(orderId,consumerId,tableName);
    }


    public int changeCreate2Fail(Long orderId, Long consumerId, String error4consumer) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeCreate2Fail(orderId,consumerId,tableName);
    }


    public int changeAfterSend2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeAfterSend2Fail(orderId,consumerId,tableName);
    }


    public int changeDuibaPay2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeDuibaPay2Fail(orderId,consumerId,tableName);
    }


    public int changeDeveloperPay2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeDeveloperPay2Fail(orderId,consumerId,tableName);
    }


    public int changeAudit2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeAudit2Fail(orderId,consumerId,tableName);
    }


    public int changeSupplierExchange2Fail(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeSupplierExchange2Fail(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markCreateComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markCreateComplete(orderId,consumerId,tableName);
    }


    /**
     * 从started -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markDeveloperPayComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markDeveloperPayComplete(orderId,consumerId,tableName);
    }


    public int markDuibaPayComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markDuibaPayComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markConsumeCreditsComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markConsumeCreditsComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markConsumerPayComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markConsumerPayComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markAuditComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markAuditComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markSupplierExchangeComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markSupplierExchangeComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markAfterSendComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markAfterSendComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markSuccessComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markSuccessComplete(orderId,consumerId,tableName);
    }


    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int markFailComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.markFailComplete(orderId,consumerId,tableName);
    }


    /**
     * 兼容处理老订单
     * 由于老订单的flowwork_stage = null
     * 这里需要将正确的flowwork_stage设置进去
     *
     * @{ String tableName = BaseOrderTool.getTableNameStr(consumerId); }
     */
    public int compatibleOldOrderStatus(Long orderId, Long consumerId, String nodeTypeKey) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.compatibleOldOrderStatus(orderId,consumerId,nodeTypeKey,tableName);
    }


    public int changeCreate2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeCreate2FailStarted(orderId,consumerId,tableName);
    }


    public int changeAfterSend2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeAfterSend2FailStarted(orderId,consumerId,tableName);
    }


    public int changeConsumeCredits2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeConsumeCredits2FailStarted(orderId,consumerId,tableName);
    }


    public int changeConsumerPay2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeConsumerPay2FailStarted(orderId,consumerId,tableName);
    }


    public int changeAudit2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeAudit2FailStarted(orderId,consumerId,tableName);
    }


    public int changeSupplierExchange2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeSupplierExchange2FailStarted(orderId,consumerId,tableName);
    }


    public int changeDeveloperPay2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeDeveloperPay2FailStarted(orderId,consumerId,tableName);
    }


    public int changeDuibaPay2FailStarted(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return flowworkStatusChangeDao.changeDuibaPay2FailStarted(orderId,consumerId,tableName);
    }


}
