package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.remoteservice.RemoteOrderFlowworkStatusChangeService;
import cn.com.duiba.order.center.biz.service.mainorder.OrderFlowworkStatusChangeService;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/21.
 */
@Service
public class RemoteOrderFlowworkStatusChangeServiceImpl implements RemoteOrderFlowworkStatusChangeService {

    @Autowired
    private OrderFlowworkStatusChangeService orderFlowworkStatusChangeService;


    @Override
    public DubboResult<Integer> changeCreate2DeveloperPay(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeCreate2DeveloperPay(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeDeveloperPay2DuibaPay(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeDeveloperPay2DuibaPay(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeDuibaPay2ConsumeCredits(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeDuibaPay2ConsumeCredits(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeConsumeCredits2ConsumerPay(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeConsumeCredits2ConsumerPay(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeConsumerPay2Audit(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeConsumerPay2Audit(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeAudit2SupplierExchange(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeAudit2SupplierExchange(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeSupplierExchange2AfterSend(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeSupplierExchange2AfterSend(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeAfterSend2Success(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeAfterSend2Success(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeCreate2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeCreate2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeConsumeCredits2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeConsumeCredits2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeConsumerPay2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeConsumerPay2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeCreate2Fail(Long orderId, Long consumerId, String error4consumer) {
        try {
            int ret = orderFlowworkStatusChangeService.changeCreate2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeAfterSend2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeAfterSend2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeDuibaPay2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeDuibaPay2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeDeveloperPay2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeDeveloperPay2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeAudit2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeAudit2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeSupplierExchange2Fail(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.changeSupplierExchange2Fail(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markCreateComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markCreateComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 从started -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markDeveloperPayComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markDeveloperPayComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> markDuibaPayComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markDuibaPayComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markConsumeCreditsComplete(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.markConsumeCreditsComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markConsumerPayComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markConsumerPayComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markAuditComplete(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.markAuditComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markSupplierExchangeComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markSupplierExchangeComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markAfterSendComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markAfterSendComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markSuccessComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markSuccessComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> markFailComplete(Long orderId, Long consumerId) {
        try {
            int ret = orderFlowworkStatusChangeService.markFailComplete(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 兼容处理老订单
     * 由于老订单的flowwork_stage = null
     * 这里需要将正确的flowwork_stage设置进去
     *
     * @param orderId
     * @param consumerId
     * @param nodeTypeString
     * @throws Exception
     */
    @Override
    public DubboResult<Integer> compatibleOldOrderStatus(Long orderId, Long consumerId, String nodeTypeKey) {
        try {
            int ret = orderFlowworkStatusChangeService.compatibleOldOrderStatus(orderId, consumerId, nodeTypeKey);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeCreate2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeCreate2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeAfterSend2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeAfterSend2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeConsumeCredits2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeConsumeCredits2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeConsumerPay2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeConsumerPay2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeAudit2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeAudit2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeSupplierExchange2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeSupplierExchange2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeDeveloperPay2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeDeveloperPay2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> changeDuibaPay2FailStarted(Long orderId, Long consumerId) throws Exception {
        try {
            int ret = orderFlowworkStatusChangeService.changeDuibaPay2FailStarted(orderId, consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }
}
