package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.remoteservice.RemoteOrderSimpleService;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSimpleService;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class RemoteOrderSimpleServiceImpl implements RemoteOrderSimpleService {

    @Autowired
    private OrderSimpleService orderSimpleService;

    /**
     * 根据订单id和用户id查询订单
     *
     * @param id
     * @param consumerId
     * @return
     */
    @Override
    public DubboResult<OrdersDO> find(Long id, Long consumerId) {
        return DubboResult.successResult(orderSimpleService.find(id, consumerId));
    }

    /**
     * 根据订单唯一编号查询订单
     *
     * @param orderNum
     * @return
     */
    @Override
    public DubboResult<OrdersDO> findByOrderNum(String orderNum) {
        return DubboResult.successResult(orderSimpleService.findByOrderNum(orderNum));
    }
}
