package cn.com.duiba.order.center.biz.service.mainorder;

import cn.com.duiba.order.center.biz.handle.MainOrderFlowworkStatusChangeHandle;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/21.
 */
@Service
public class OrderFlowworkStatusChangeService {

    @Autowired
    private MainOrderFlowworkStatusChangeHandle mainOrderFlowworkStatusChangeHandle;

    @Autowired
    private OrderSyncService orderSyncService;

    //扣费节点新增方法
    public int changeCreate2DeveloperPay(Long orderId, Long consumerId) throws BusinessException {

        int ret = mainOrderFlowworkStatusChangeHandle.changeCreate2DeveloperPay(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    //扣费节点新增方法
    public int changeDeveloperPay2DuibaPay(Long orderId, Long consumerId) throws BusinessException {

        int ret = mainOrderFlowworkStatusChangeHandle.changeDeveloperPay2DuibaPay(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    //扣费节点新增方法
    public int changeDuibaPay2ConsumeCredits(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeDuibaPay2ConsumeCredits(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeConsumeCredits2ConsumerPay(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeConsumeCredits2ConsumerPay(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeConsumerPay2Audit(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeConsumerPay2Audit(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeAudit2SupplierExchange(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeAudit2SupplierExchange(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeSupplierExchange2AfterSend(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeSupplierExchange2AfterSend(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeAfterSend2Success(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeAfterSend2Success(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeCreate2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeCreate2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeConsumeCredits2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeConsumeCredits2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeConsumerPay2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeConsumerPay2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeCreate2Fail(Long orderId, Long consumerId, String error4consumer) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeCreate2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeAfterSend2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeAfterSend2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeDuibaPay2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeDuibaPay2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeDeveloperPay2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeDeveloperPay2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeAudit2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeAudit2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeSupplierExchange2Fail(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeSupplierExchange2Fail(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markCreateComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markCreateComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 从started -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markDeveloperPayComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markDeveloperPayComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int markDuibaPayComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markDuibaPayComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markConsumeCreditsComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markConsumeCreditsComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markConsumerPayComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markConsumerPayComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markAuditComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markAuditComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markSupplierExchangeComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markSupplierExchangeComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markAfterSendComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markAfterSendComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markSuccessComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markSuccessComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 强制从 strated -> complete
     *
     * @param orderId
     * @return
     * @throws Exception
     */
    public int markFailComplete(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.markFailComplete(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 兼容处理老订单
     * 由于老订单的flowwork_stage = null
     * 这里需要将正确的flowwork_stage设置进去
     *
     * @throws Exception
     */
    public int compatibleOldOrderStatus(Long orderId, Long consumerId, String nodeTypeKey) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.compatibleOldOrderStatus(orderId, consumerId, nodeTypeKey);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }


    public int changeCreate2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeCreate2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeAfterSend2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeAfterSend2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeConsumeCredits2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeConsumeCredits2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeConsumerPay2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeConsumerPay2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeAudit2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeAudit2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeSupplierExchange2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeSupplierExchange2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeDeveloperPay2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeDeveloperPay2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public int changeDuibaPay2FailStarted(Long orderId, Long consumerId) throws BusinessException {
        int ret = mainOrderFlowworkStatusChangeHandle.changeDuibaPay2FailStarted(orderId, consumerId);
        if (ret != 1) {
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }


}
