package cn.com.duiba.order.center.biz.service.mainorder;

import cn.com.duiba.order.center.biz.handle.MainOrderSimpleHandle;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class OrderSimpleService {
    @Autowired
    private MainOrderSimpleHandle mainOrderSimpleHandle;

    /**
     * 根据订单id和用户id查询订单
     * @param id
     * @param consumerId
     * @return
     */
    public OrdersDO find(Long id, Long consumerId) {
        return mainOrderSimpleHandle.find(id,consumerId);
    }

    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
    public OrdersDO findByOrderNum(String orderNum) {
        return mainOrderSimpleHandle.findByOrderNum(orderNum);
    }
}
