package cn.com.duiba.order.center.biz.service.mainorder;


import cn.com.duiba.order.center.api.dto.OrderSyncMessageDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderSyncService  {

	private static Logger log = LoggerFactory.getLogger(OrderSyncService.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private TopicConstant topicConstant;

	public void sync(Long orderId, Long consumerId) {
		try {
			//发送消息到MQ
			OrderSyncMessageDto msg = new OrderSyncMessageDto();
			msg.setOrderId(orderId);
			msg.setConsumerId(consumerId);
			String body = JSONObject.toJSONString(msg);
			messageService.sendMsg(topicConstant.getTopicOrdersDataSync(), body);
		} catch (Exception e) {
			log.error("order sync error:[orderId:" + orderId + " consumerId:" + consumerId + "]", e);
		}
	}

}
