/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.message;

import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.tool.KafkaClient;
import cn.com.duiba.pinellie.agent.PTransactions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
    private static Logger log = LoggerFactory.getLogger(MessageService.class);
    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private TopicConstant topicConstant;
    private ExecutorService executorService = Executors.newFixedThreadPool(5, new ThreadFactory(){
        private int i = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Thread-DataSync-" + this.i++);
        }
    });

    public void sendMsg(final String queueName, final String body) {
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                PTransactions transactions = PTransactions.newTransactions().build();
                Exception ex = null;
                for (int i = 0; i < 3; ++i) {
                    try {
                        MessageService.this.kafkaClient.sendMsg(queueName, body);
                        transactions.logMetricForCount("QUEUE-SUCCESS-ALL");
                        transactions.logMetricForCount("QUEUE-" + queueName + "-SUCCESS");
                        return;
                    }
                    catch (Exception e) {
                        ex = e;
                        continue;
                    }
                }
                if (ex == null) return;
                transactions.logMetricForCount("QUEUE-ALL-FAIL");
                transactions.logMetricForCount("QUEUE-" + queueName + "-FAIL");
                log.error("sendMsg:queueName=" + queueName + ",body=" + body, (Throwable)ex);
                return;
                finally {
                    transactions.complete();
                }
            }
        });
    }
}

