package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteSupplierProductsService;
import cn.com.duiba.order.center.biz.service.credits.SupplierProductsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/27.
 */
@Service
public class RemoteSupplierProductsServiceImpl implements RemoteSupplierProductsService {

    @Autowired
    private SupplierProductsService supplierProductsService;

    @Override
    public DubboResult<SupplierProductDto> findBySupplier(String supplier) {
        return DubboResult.successResult(supplierProductsService.findBySupplier(supplier));
    }

    @Override
    public DubboResult<SupplierProductDto> insert(SupplierProductDto supplierProductDto) {
        return DubboResult.successResult(supplierProductsService.insert(supplierProductDto));
    }

    @Override
    public DubboResult<SupplierProductDto> findById(Long id) {
        return DubboResult.successResult(supplierProductsService.findById(id));
    }
}
