package cn.com.duiba.order.center.biz.service.consumerrecord;

import cn.com.duiba.order.center.api.dto.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordSequenceEntity;
import cn.com.duiba.order.center.biz.entity.CrecordSyncMessage;
import cn.com.duiba.order.center.biz.handle.ConsumerExchangeRecordHandle;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/30.
 */
@Service
public class ConsumerExchangeRecordService {

    private static Logger log = LoggerFactory.getLogger(ConsumerExchangeRecordService.class);


    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;

    @Autowired
    private ConsumerExchangeRecordHandle consumerExchangeRecordHandle;
    public void insert(ConsumerExchangeRecordDto consumerExchangeRecordDto) {
        ConsumerExchangeRecordEntity entity= BeanUtils.copy(consumerExchangeRecordDto,ConsumerExchangeRecordEntity.class);
        entity.setId(getSequenceID(new ConsumerExchangeRecordSequenceEntity()));
        consumerExchangeRecordHandle.insert(entity);
        consumerExchangeRecordDto.setId(entity.getId());
        sendSyncMessage(entity.getConsumerId(),entity.getId());
    }

    private long getSequenceID(ConsumerExchangeRecordSequenceEntity consumerExchangeRecordSequenceEntity) {
        consumerExchangeRecordHandle.getSequenceID(consumerExchangeRecordSequenceEntity);
        return consumerExchangeRecordSequenceEntity.getId();
    }

    public void sendSyncMessage(Long consumerId, Long id) {
        try {
            CrecordSyncMessage message = new CrecordSyncMessage();
            message.setConsumerId(consumerId);
            message.setId(id);
            String body = JSONObject.toJSONString(message);
            messageService.sendMsg(topicConstant.getTopicCrecord(), body);
        } catch (Exception e) {
            log.error("sendSyncMessage error: [consumerId " + consumerId + "] [crecordId " + id + "]", e);
        }
    }
}
