/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.ConfigConstant;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.dao.credits.SupplierProductsDao;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.order.center.biz.exchangecreator.BaseCreator;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPayCreator
extends BaseCreator {
    private static Logger log = LoggerFactory.getLogger(AliPayCreator.class);
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConfigConstant configConstant;
    @Autowired
    private MessageService messageService;
    @Autowired
    private SupplierProductsDao supplierProductsDao;

    public void createOrder(OrdersEntity order, RequestParams params) throws Exception {
        if (order == null) {
            throw new Exception("\u8ba2\u5355\u4e3a\u7a7a");
        }
        Long supplierProductId = this.getSupplierId();
        if (supplierProductId == null) {
            throw new Exception("\u6ca1\u6709\u4f9b\u5e94\u5546");
        }
        this.takeOrder(order);
        OrderCreateContext orderCreateContext = new OrderCreateContext();
        orderCreateContext.setOrderId(order.getId());
        orderCreateContext.setConsumerId(order.getConsumerId());
        orderCreateContext.setParams(params);
        orderCreateContext.setChargeMode(order.getChargeMode());
        orderCreateContext.setSupplierProductId(supplierProductId);
        orderCreateContext.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        this.messageService.sendMsg(this.topicConstant.getAlipayOrderCreatePart(), JSONObject.toJSONString((Object)orderCreateContext));
        log.error("send order :" + this.topicConstant.getAlipayOrderCreatePart() + "|" + order.getId());
    }

    private Long getSupplierId() {
        int alipayWeitht = Integer.valueOf(this.configConstant.alipayWeight);
        int thirdWeight = Integer.valueOf(this.configConstant.thirdpayWeight);
        SupplierProductEntity alipaySp = this.supplierProductsDao.findBySupplier("alipay-official");
        if (alipaySp == null) {
            return null;
        }
        if (thirdWeight == 0) {
            return alipaySp.getId();
        }
        SupplierProductEntity thirdpaySp = this.supplierProductsDao.findBySupplier("thirdpay-zhongxiang");
        if (thirdpaySp == null) {
            return alipaySp.getId();
        }
        HashMap<Long, Integer> suppliers = new HashMap<Long, Integer>();
        suppliers.put(alipaySp.getId(), alipayWeitht);
        suppliers.put(thirdpaySp.getId(), thirdWeight);
        int sum = alipayWeitht + thirdWeight;
        Integer rand = new Random().nextInt(sum) + 1;
        for (Map.Entry entry : suppliers.entrySet()) {
            if ((rand = Integer.valueOf(rand - (Integer)entry.getValue())) > 0) continue;
            return (Long)entry.getKey();
        }
        return alipaySp.getId();
    }
}

