/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.message;

import cn.com.duiba.order.center.biz.tool.KafkaClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
    private static Logger log = LoggerFactory.getLogger(MessageService.class);
    @Autowired
    private KafkaClient kafkaClient;
    private ExecutorService executorService = Executors.newFixedThreadPool(5, new ThreadFactory(){
        private int i = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Thread-DataSync-" + this.i++);
        }
    });

    public void sendMsg(final String queueName, final String body) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                Exception ex = null;
                for (int i = 0; i < 3; ++i) {
                    try {
                        MessageService.this.kafkaClient.sendMsg(queueName, body);
                        return;
                    }
                    catch (Exception e) {
                        ex = e;
                        continue;
                    }
                }
                if (ex != null) {
                    log.error("sendMsg:queueName=" + queueName + ",body=" + body, (Throwable)ex);
                }
            }
        });
    }
}

