package cn.com.duiba.order.center.biz.entity;

import cn.com.duiba.order.center.api.dto.OrdersBackupDto;

import java.util.Date;

/**
 * @author yansen
 */
public class OrdersBackupEntity {

	private Long id;
	private String orderNum;// 订单号
	private Long developerId;
	private Long appId;
	private Long consumerId;
	private Long itemId;
	private Long appItemId;
	private Long couponId;
	private String type;// qb phonebill coupon
	private Integer facePrice;
	private Integer actualPrice;
	private Long credits;// 消耗的积分数
	private Integer quantity;
	private String bizParams; // 业务参数，比如qq号码

	private String status;// 处理中 成功 失败
	private String errorMessage;
	private String failReason; // 失败原因，主要是给用户看的

	private String error4Consumer;// 给用户的出错提示
	private String error4Developer; // 给开发者的出错提示
	private String error4Admin;// 给兑吧管理员的出错提示

	private String payStatus;// 预扣费 扣费成功 已反冲
	private String auditStatus;

	private Boolean allowInputAgain; // 是否允许用户再次填写，重新兑换
	private String allowInputTips; // 允许用户再次填写时，给用户的提示语

	private Date auditTime; // 审核时间

	private String developerBizId; // 开发者的业务id

	private Long supplierOrderId;

	private Date finishTime;// 订单结束时间

	private String chargeMode;// 充值模式 api mall 默认mall
	private String brief;

	private String ip;
	private Integer notify;// 通知状态 null 1-通知次数

	private Date lastSendTime;// 上游请求发送时间
	private Integer failType; // 失败类型 0-成功 1-上游失败 2-开发者服务器异常 3-开发者反馈失败 4审核拒绝

	private Long relationId;// 关联对象id，如果ChargeMode=turntable，则此为大转盘订单id
	private Integer relationType;

	private Date gmtCreate;
	private Date gmtModified;
	
	private Long orderId;
	private String payCenterMessage;
	
	private Integer duibaActualPrice; 	
	private String duibaPayStatus;
	
	private Long subOrderId;// 子订单ID
	private String subOrderType;// 子订单类型 amb:加钱购
	private String consumerPayStatus;// 用户付款状态 none | wait_pay | pay_success |
									 // pay_back | canceled | success
	private Long consumerPayPrice;// 用户支付金额
	private Long consumerPayBackPrice;//
	
	private String flowworkStage;

	/**
	 *  默认构造函数
	 */
	public OrdersBackupEntity() {
		super();
	}

	/**
	 *
	 * @param id
     */
	public OrdersBackupEntity(Long id) {
		this.id = id;
		this.gmtModified=new Date();
	}

	/**
	 *
	 * @param init4insert
     */
	public OrdersBackupEntity(boolean init4insert) {
		if (init4insert) {
			failType = 0;
			allowInputAgain = false;
			facePrice = 0;
			payStatus = OrdersBackupDto.PayStatusPrereduce;
			auditStatus = OrdersBackupDto.AuditStatusNotNeed;
			relationType = OrdersBackupDto.RelationTypeDefault;

			duibaPayStatus=OrdersBackupDto.DuibaPayStatusNone;
			consumerPayPrice=0l;
			consumerPayBackPrice=0l;
			
			duibaActualPrice=0;
		
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}

	public Long getDeveloperId() {
		return developerId;
	}

	public void setDeveloperId(Long developerId) {
		this.developerId = developerId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}


	public Integer getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Integer facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getActualPrice() {
		return actualPrice;
	}

	public void setActualPrice(Integer actualPrice) {
		this.actualPrice = actualPrice;
	}

	public Long getCredits() {
		return credits;
	}

	public void setCredits(Long credits) {
		this.credits = credits;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public String getBizParams() {
		return bizParams;
	}

	public void setBizParams(String bizParams) {
		this.bizParams = bizParams;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getFailReason() {
		return failReason;
	}

	public void setFailReason(String failReason) {
		this.failReason = failReason;
	}

	public String getError4Consumer() {
		return error4Consumer;
	}

	public void setError4Consumer(String error4Consumer) {
		if (error4Consumer != null && error4Consumer.length() > 255) {
			this.error4Consumer = error4Consumer.substring(0, 255);
		} else {
			this.error4Consumer = error4Consumer;
		}
	}

	public String getError4Developer() {
		return error4Developer;
	}

	public void setError4Developer(String error4Developer) {
		if (error4Developer != null && error4Developer.length() > 255) {
			this.error4Developer = error4Developer.substring(0, 255);
		} else {
			this.error4Developer = error4Developer;
		}
	}

	public String getError4Admin() {
		return error4Admin;
	}

	public void setError4Admin(String error4Admin) {
		if (error4Admin != null && error4Admin.length() > 255) {
			this.error4Admin = error4Admin.substring(0, 255);
		} else {
			this.error4Admin = error4Admin;
		}
	}

	public String getPayStatus() {
		return payStatus;
	}

	public void setPayStatus(String payStatus) {
		this.payStatus = payStatus;
	}

	public String getAuditStatus() {
		return auditStatus;
	}

	public void setAuditStatus(String auditStatus) {
		this.auditStatus = auditStatus;
	}


	public Boolean getAllowInputAgain() {
		return allowInputAgain;
	}

	public void setAllowInputAgain(Boolean allowInputAgain) {
		this.allowInputAgain = allowInputAgain;
	}

	public String getAllowInputTips() {
		return allowInputTips;
	}

	public void setAllowInputTips(String allowInputTips) {
		this.allowInputTips = allowInputTips;
	}

	public Date getAuditTime() {
		return auditTime;
	}

	public void setAuditTime(Date auditTime) {
		this.auditTime = auditTime;
	}

	public String getDeveloperBizId() {
		return developerBizId;
	}

	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}

	public Long getSupplierOrderId() {
		return supplierOrderId;
	}

	public void setSupplierOrderId(Long supplierOrderId) {
		this.supplierOrderId = supplierOrderId;
	}

	public Date getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	public String getChargeMode() {
		return chargeMode;
	}

	public void setChargeMode(String chargeMode) {
		this.chargeMode = chargeMode;
	}

	public String getBrief() {
		return brief;
	}

	public void setBrief(String brief) {
		this.brief = brief;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public Integer getNotify() {
		return notify;
	}

	public void setNotify(Integer notify) {
		this.notify = notify;
	}

	public Date getLastSendTime() {
		return lastSendTime;
	}

	public void setLastSendTime(Date lastSendTime) {
		this.lastSendTime = lastSendTime;
	}

	public Integer getFailType() {
		return failType;
	}

	public void setFailType(Integer failType) {
		this.failType = failType;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Integer getRelationType() {
		return relationType;
	}

	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}

	public Long getOrderId()
	{
		return orderId;
	}

	public void setOrderId(Long orderId)
	{
		this.orderId = orderId;
	}

	public String getPayCenterMessage()
	{
		return payCenterMessage;
	}

	public void setPayCenterMessage(String payCenterMessage)
	{
		this.payCenterMessage = payCenterMessage;
	}

	public Integer getDuibaActualPrice()
	{
		return duibaActualPrice;
	}

	public void setDuibaActualPrice(Integer duibaActualPrice)
	{
		this.duibaActualPrice = duibaActualPrice;
	}

	public String getDuibaPayStatus()
	{
		return duibaPayStatus;
	}

	public void setDuibaPayStatus(String duibaPayStatus)
	{
		this.duibaPayStatus = duibaPayStatus;
	}

	public Long getSubOrderId()
	{
		return subOrderId;
	}

	public void setSubOrderId(Long subOrderId)
	{
		this.subOrderId = subOrderId;
	}

	public String getSubOrderType()
	{
		return subOrderType;
	}

	public void setSubOrderType(String subOrderType)
	{
		this.subOrderType = subOrderType;
	}

	public String getConsumerPayStatus()
	{
		return consumerPayStatus;
	}

	public void setConsumerPayStatus(String consumerPayStatus)
	{
		this.consumerPayStatus = consumerPayStatus;
	}

	public Long getConsumerPayPrice()
	{
		return consumerPayPrice;
	}

	public void setConsumerPayPrice(Long consumerPayPrice)
	{
		this.consumerPayPrice = consumerPayPrice;
	}

	public Long getConsumerPayBackPrice()
	{
		return consumerPayBackPrice;
	}

	public void setConsumerPayBackPrice(Long consumerPayBackPrice)
	{
		this.consumerPayBackPrice = consumerPayBackPrice;
	}

	public String getFlowworkStage()
	{
		return flowworkStage;
	}

	public void setFlowworkStage(String flowworkStage)
	{
		this.flowworkStage = flowworkStage;
	}

}
