package cn.com.duiba.order.center.biz.exchangecreator;

import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.utils.BeanUtils;


/**
 * Created by yansen on 16/11/16.
 */
@Service
public class PcgCouponCreator extends BaseCreator {
    @Autowired
    private TopicConstant topicConstant;

    @Autowired
    private MessageService messageService;

    /**
     * 平台券券-下单操作
     * @param order 订单对象
     * @param couponId 优惠券id
     * @param params http参数
     * @throws Exception
     */
    public OrdersDto takePcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param)throws Exception{
        OrdersDto order = new OrdersDto(true);
        order.setIp(param.getIp());
        order.setChargeMode(OrdersDto.ChargeModeMall);
        order.setOrderNum(param.getOrderNum());
        order.setConsumerId(param.getConsumerId());
        order.setAppId(param.getAppId());


        order.setDeveloperId(param.getDeveloperId());

        order.setCouponId(param.getCouponId());

        order.setQuantity(1);
        order.setStatus(OrdersDto.StatusCreate);
        order.setType(ItemDO.TypeCoupon);

        order.setActualPrice(0);
        order.setPayStatus(OrdersDto.PayStatusNone);

        order.setDuibaActualPrice(0);
        order.setDuibaPayStatus(OrdersDto.DuibaPayStatusNone);

        order.setConsumerPayPrice(0L);
        order.setConsumerPayStatus(OrdersDto.ConsumerPayStatusNone);

        // 是否可以采用default
        order.setRelationType(OrdersDto.RelationTypeDefault);
        order.setRelationId(null);

        if(param.getCredits()<=0){
            throw new BusinessException("积分必须大于0");
        }
        order.setCredits(param.getCredits());
        order.setAuditStatus(OrdersDto.AuditStatusNotNeed);
        order.setItemId(param.getPcgId());

        order.setBrief(param.getBrief());
        order.setFacePrice(param.getFacePrice());

        order.setTypeInt(GoodsTypeEnum.PLATFORM.getGtype());



        try {
            TimeProfile.enter("takeOrderIntimes");
            OrdersEntity entity= BeanUtils.copy(order,OrdersEntity.class);
            takePcgOrder(entity);
            order.setId(entity.getId());
            order.setOrderNum(entity.getOrderNum());
        } catch (Exception e) {
            //抛出异常，表明需要回滚
            throw e;
        } finally{
            TimeProfile.release();
        }
        RequestParams localRequestParam=new RequestParams();
        localRequestParam.setConsumerId(param.getConsumerId());
        localRequestParam.setCookies(param.getCookies());
        localRequestParam.setIp(param.getIp());
        localRequestParam.setUserAgent(param.getUserAgent());

        HashMap<String, Object> extraParam=new HashMap<>();
        extraParam.put("overDue",param.getOverDue());

        OrderCreateContext orderCreateContext = new OrderCreateContext();
        orderCreateContext.setOrderId(order.getId());
        orderCreateContext.setConsumerId(order.getConsumerId());
        orderCreateContext.setParams(localRequestParam);
        orderCreateContext.setChargeMode(order.getChargeMode());
        orderCreateContext.setParamsMap(extraParam);
        //orderCreateContext.setCouponId(couponId);
        orderCreateContext.setTimestamp(System.currentTimeMillis());
        messageService.sendMsg(topicConstant.getPcgCouponOrderCreatePart(), JSONObject.toJSONString(orderCreateContext));
        return order;
    }


}
