package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by yansen on 16/12/5.
 * 流量订单创建
 */
@Component
public class PhoneFlowCreator extends BaseCreator {


    @Autowired
    private TopicConstant topicConstant;

    @Autowired
    private MessageService messageService;

    /**
     * 话费-普通兑换-下单操作
     * @param order 订单对象
     * @param supplierProductId 供应商id
     * @param params http参数
     * @throws Exception
     */
    public void createOrder(OrdersEntity order, Long supplierProductId, RequestParams params) throws Exception{
        if(order == null){
            throw new BusinessException("订单为空");
        }
        // 创建订单
        takeOrder(order);

        OrderCreateContext orderCreateContext = new OrderCreateContext();
        orderCreateContext.setOrderId(order.getId());
        orderCreateContext.setConsumerId(order.getConsumerId());
        orderCreateContext.setParams(params);
        orderCreateContext.setChargeMode(order.getChargeMode());
        orderCreateContext.setSupplierProductId(supplierProductId);
        orderCreateContext.setTimestamp(System.currentTimeMillis());
        // 订单异步处理消息
        messageService.sendMsg(topicConstant.getPhoneflowOrderCreatePart(), JSONObject.toJSONString(orderCreateContext));
    }
}
