package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.AlipayBatchLogDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteAlipayBatchLogService;
import cn.com.duiba.order.center.biz.service.credits.AlipayBatchLogService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/10/26.
 */
@Service
public class RemoteAlipayBatchLogServiceImpl implements RemoteAlipayBatchLogService {
    @Autowired
    private AlipayBatchLogService alipayBatchLogService;

    @Override
    public DubboResult<AlipayBatchLogDto> insert(AlipayBatchLogDto alipayBatchLogDto) {
        return DubboResult.successResult(alipayBatchLogService.insert(alipayBatchLogDto));
    }

    @Override
    public DubboResult<AlipayBatchLogDto> update(AlipayBatchLogDto alipayBatchLogDto) {
        return DubboResult.successResult(alipayBatchLogService.update(alipayBatchLogDto));
    }

    @Override
    public DubboResult<AlipayBatchLogDto> findByBatchNo(String batchNo) {
        return DubboResult.successResult(alipayBatchLogService.findByBatchNo(batchNo));
    }

}
