package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.AmbOrderFastDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteAmbOrderFastService;
import cn.com.duiba.order.center.biz.bo.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.service.credits.AmbOrderFastService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by yansen on 16/9/26.
 */
@Service
public class RemoteAmbOrderFastServiceImpl implements RemoteAmbOrderFastService {

    @Autowired
    private AmbOrderFastBo ambOrderFastBo;

    @Autowired
    private AmbOrderFastService ambOrderFastService;

    @Override
    public DubboResult<AmbOrderFastDto> createOrderFastWaitPay(Long orderId, Long consumerId, Date orderGmtCreate) {
        return DubboResult.successResult(ambOrderFastBo.createOrderFastWaitPay(orderId,consumerId,orderGmtCreate));
    }

    @Override
    public DubboResult<Integer> deleteByOrderId(Long orderId) {
        return DubboResult.successResult(ambOrderFastService.deleteByOrderId(orderId));
    }

    @Override
    public DubboResult<AmbOrderFastDto> createOrderFastWaitReceive(Long orderId, Long consumerId){
        return DubboResult.successResult(ambOrderFastBo.createOrderFastWaitReceive(orderId,consumerId));
    }
}
