package cn.com.duiba.order.center.biz.service.consumerrecord;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.order.center.api.dto.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordSequenceEntity;
import cn.com.duiba.order.center.biz.entity.CrecordSyncMessage;
import cn.com.duiba.order.center.biz.handle.ConsumerExchangeRecordHandle;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/9/30.
 */
@Service
public class ConsumerExchangeRecordService {

    private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(ConsumerExchangeRecordService.class);


    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;

    @Autowired
    private ConsumerExchangeRecordHandle consumerExchangeRecordHandle;

    /**
     *
     * @param consumerExchangeRecordDto
     */
    public void insert(ConsumerExchangeRecordDto consumerExchangeRecordDto) {
        ConsumerExchangeRecordEntity entity= BeanUtils.copy(consumerExchangeRecordDto,ConsumerExchangeRecordEntity.class);
        entity.setId(getSequenceID(new ConsumerExchangeRecordSequenceEntity()));
        consumerExchangeRecordHandle.insert(entity);
        consumerExchangeRecordDto.setId(entity.getId());
        sendSyncMessage(entity.getConsumerId(),entity.getId());
    }
    
	public ConsumerExchangeRecordEntity selectOneByMapCondition(Map<String, Object> map) {
		return consumerExchangeRecordHandle.selectOneByMapCondition(map);
	}

    /**
     *
     * @param map
     * @return
     */
	public List<ConsumerExchangeRecordEntity> selectListByMapCondition(Map<String, Object> map) {
		return consumerExchangeRecordHandle.selectListByMapCondition(map);
	}

    /**
     *
     * @param map
     * @return
     */
	public List<ConsumerExchangeRecordEntity> selectPageListByMapCondition(Map<String, Object> map) {
		return consumerExchangeRecordHandle.selectPageListByMapCondition(map);
	}

    /**
     *
     * @param entity
     * @return
     */
	public Boolean update(ConsumerExchangeRecordEntity entity) {
		int ret = consumerExchangeRecordHandle.update(entity);
		if(ret < 1){
			return false;
		}
		sendSyncMessage(entity.getConsumerId(),entity.getId());
		return true;
	}
    
    private long getSequenceID(ConsumerExchangeRecordSequenceEntity consumerExchangeRecordSequenceEntity) {
        consumerExchangeRecordHandle.getSequenceID(consumerExchangeRecordSequenceEntity);
        return consumerExchangeRecordSequenceEntity.getId();
    }

    private void sendSyncMessage(Long consumerId, Long id) {
        try {
            CrecordSyncMessage message = new CrecordSyncMessage();
            message.setConsumerId(consumerId);
            message.setId(id);
            String body = JSONObject.toJSONString(message);
            messageService.sendMsg(topicConstant.getTopicCrecord(), body);
        } catch (Exception e) {
            log.error("sendSyncMessage error: [consumerId " + consumerId + "] [crecordId " + id + "]", e);
        }
    }
}
