package cn.com.duiba.order.center.biz.service.mainorder.orderconsumer;

import cn.com.duiba.order.center.biz.handle.OrdersTextChangeHandle;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
@Service
public class OrdersTextChangeService {

    @Autowired
    private OrdersTextChangeHandle ordersTextChangeHandle;

    @Autowired
    private OrderSyncService orderSyncService;

    /**
     * 更新订单错误信息，状态，错误类型
     *
     * @param orderId
     * @param consumerId
     * @param failType
     * @param status
     * @param errorMessage
     * @param error4Consumer
     * @param error4Develper
     * @param error4Admin
     * @return
     */
    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage,
                                                 String error4Consumer, String error4Develper, String error4Admin) {
        Integer ret= ordersTextChangeHandle.updateErrorMessageAndFailType(orderId,consumerId,failType,errorMessage,error4Consumer,error4Develper,error4Admin);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 更新最后发送时间
     * @param orderId
     * @param consumerId
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        Integer ret= ordersTextChangeHandle.updateLastSendTime(orderId,consumerId,lastSendTime);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 更新开发者订单号
     * @param orderId
     * @param consumerId
     * @param developBizId
     * @return
     */
    public Integer updateDevelopBizId(Long orderId,Long consumerId, String developBizId){
        Integer ret= ordersTextChangeHandle.updateDevelopBizId(orderId,consumerId,developBizId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 更新上游订单
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @return
     */
    public Integer updateSupplierOrderId(Long orderId,  Long consumerId, Long supplierOrderId){
        Integer ret= ordersTextChangeHandle.updateSupplierOrderId(orderId,consumerId,supplierOrderId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 释放一张优惠券
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer releaseCouponByOrderId(Long orderId, Long consumerId){
        Integer ret= ordersTextChangeHandle.releaseCouponByOrderId(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 下订单,更新优惠券ID
     * @param orderId
     * @param consumerId
     * @param couponId
     * @return
     */
    public Integer updateCouponId(Long orderId,Long consumerId,Long couponId){
        Integer ret= ordersTextChangeHandle.updateCouponId(orderId,consumerId,couponId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param subId
     * @return
     */
    public Integer updateSubOrderIdById(Long orderId,Long consumerId, Long subId){
        Integer ret= ordersTextChangeHandle.updateSubOrderIdById(orderId,consumerId,subId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }
}
