package cn.com.duiba.order.center.biz.service.mainorder.orderhouse;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.biz.dao.orderhouse.OrderHouseSimpleDao;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class OrderHouseSimpleService {

    @Autowired
    private OrderHouseSimpleDao orderHouseSimpleDao;

    /**
     *
     * @param orderNum
     * @return
     */
    public OrdersDto findByOrderNum(String orderNum) {
        return BeanUtils.copy(orderHouseSimpleDao.findByOrderNum(orderNum), OrdersDto.class);
    }

    /**
     *
     * @param id
     * @return
     */
    public OrdersDto findById(Long id){
        return BeanUtils.copy(orderHouseSimpleDao.find(id),OrdersDto.class);
    }

    /**
     *
     * @param ids
     * @return
     */
    public List<OrdersDto> findAllByIds(List<Long> ids){
        return BeanUtils.copyList(orderHouseSimpleDao.findAllByIds(ids),OrdersDto.class);
    }
}
