package cn.com.duiba.order.center.biz.service.message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.order.center.biz.tool.KafkaClient;

/**
 * 消息队列service
 */
@Component
public class MessageService {

	private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(MessageService.class);

	@Autowired
	private KafkaClient kafkaClient;

	/**
	 * sendMsg
	 * 
	 * @param queueName
	 * @param body
	 */
	public void sendMsg(final String queueName, final String body) {
		try {
			kafkaClient.sendMsg(queueName, body);
		} catch (Exception e) {
			log.error("sendMsg",e);
		}
	}

}
