package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.order.center.api.dto.AmbOrderFastDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.biz.service.credits.AmbOrderFastService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrderSimpleService;
import cn.com.duiba.wolf.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by yansen on 16/9/26.
 */
@Service
public class AmbOrderFastBo {
    @Autowired
    private AmbOrderFastService ambOrderFastService;

    @Autowired
    private OrderSimpleService orderSimpleService;

    /**
     *
     * @param orderId
     * @param consumerId
     * @param orderGmtCreate
     * @return
     */
    public AmbOrderFastDto createOrderFastWaitPay(Long orderId, Long consumerId, Date orderGmtCreate) {
        Date scanTime = DateUtils.minutesAddOrSub(orderGmtCreate, AmbOrderFastDto.ScanTime30Minute);
        return innerCreateOrderFast(orderId, consumerId, AmbOrderFastDto.OrderFastTypeWaitPay, scanTime);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public AmbOrderFastDto createOrderFastMaxTime(Long orderId, Long consumerId) {
        Date scanTime = DateUtils.daysAddOrSub(new Date(), AmbOrderFastDto.ScanTime60Day);
        return innerCreateOrderFast(orderId, consumerId, AmbOrderFastDto.OrderFastTypeMaxTime, scanTime);
    }

    public AmbOrderFastDto createOrderFastWaitReceive(Long orderId, Long consumerId){
        Date scanTime = DateUtils.daysAddOrSub(new Date(), AmbOrderFastDto.ScanTime7Day);
        return innerCreateOrderFast(orderId, consumerId, AmbOrderFastDto.OrderFastTypeWaitReceive, scanTime);
    }

    private AmbOrderFastDto innerCreateOrderFast(Long orderId, Long consumerId, String orderFastType, Date scanTime) {
        OrdersDto order = orderSimpleService.findById(orderId, consumerId);
        AmbOrderFastDto fast = new AmbOrderFastDto();
        fast.setConsumerId(order.getConsumerId());
        fast.setOrderId(order.getId());
        fast.setAppId(order.getAppId());
        fast.setAmbSubOrderId(order.getSubOrderId());
        fast.setOrderFastType(orderFastType);
        fast.setScanTime(scanTime);
        return ambOrderFastService.insert(fast);
    }
}
