package cn.com.duiba.order.center.biz.bo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.order.center.api.dto.OrderAuditMessageDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;

/**
 * Created by yansen on 16/9/29.
 */
@Service
public class AuditBo {

    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;

    /**
     *
     * @param orderId
     */
    public void doAuditPass(Long orderId) {
        OrderAuditMessageDto messageDto=new OrderAuditMessageDto(orderId,true);
        messageService.sendMsg(topicConstant.getTopicOrderAudit(), JSONObject.toJSONString(messageDto));
    }

    /**
     *
     * @param orderId
     */
    public void doAuditReject(Long orderId) {
        OrderAuditMessageDto messageDto=new OrderAuditMessageDto(orderId,false);
        messageService.sendMsg(topicConstant.getTopicOrderAudit(), JSONObject.toJSONString(messageDto));
    }
}
