package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.order.center.api.dto.ObjectOrderCancelDto;
import cn.com.duiba.order.center.api.dto.ObjectOrderSendDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/12/12.
 */
@Service
public class MainOrderFlowworkBo {
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;



    public void executeObjectCancel(Long orderId, String reason4consumer) {
        ObjectOrderCancelDto objectOrderCancelDto = new ObjectOrderCancelDto();
        objectOrderCancelDto.setType(ObjectOrderCancelDto.TYPE_NORMAL);
        objectOrderCancelDto.setOrderId(orderId);
        objectOrderCancelDto.setReason4consumer(reason4consumer);
        messageService.sendMsg(topicConstant.getTopicOrderCancel(), JSONObject.toJSONString(objectOrderCancelDto));
    }

    public void adminCanceOrder(Long orderId, String errorMassage) {
        ObjectOrderCancelDto objectOrderCancelDto = new ObjectOrderCancelDto();
        objectOrderCancelDto.setType(ObjectOrderCancelDto.TYPE_ADMIN);
        objectOrderCancelDto.setOrderId(orderId);
        objectOrderCancelDto.setReason4consumer(errorMassage);
        messageService.sendMsg(topicConstant.getTopicOrderCancel(), JSONObject.toJSONString(objectOrderCancelDto));
    }

    public void executeObjectSend(Long orderId, String expressName, String expressId) {
        ObjectOrderSendDto objectOrderSendDto = new ObjectOrderSendDto();
        objectOrderSendDto.setExpressId(expressId);
        objectOrderSendDto.setExpressName(expressName);
        objectOrderSendDto.setOrderId(orderId);
        objectOrderSendDto.setType(ObjectOrderSendDto.SEND_TYPE_NORMAL);
        messageService.sendMsg(topicConstant.getTopicOrderSend(), JSONObject.toJSONString(objectOrderSendDto));
    }

    public void executeManualLotterySend(Long orderId, String deliverInfo){
        ObjectOrderSendDto objectOrderSendDto = new ObjectOrderSendDto();
        objectOrderSendDto.setOrderId(orderId);
        objectOrderSendDto.setDeliverInfo(deliverInfo);
        objectOrderSendDto.setType(ObjectOrderSendDto.SEND_TYPE_MANUAL_LOTTERY);
        messageService.sendMsg(topicConstant.getTopicOrderSend(), JSONObject.toJSONString(objectOrderSendDto));
    }

}
