package cn.com.duiba.order.center.biz.dao.activity;

import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 
 * @author zhaodongxue
 *
 */
public interface ActivityOrderDao {

	/**
	 *
	 * @param entity
     */
	public void insert(ActivityOrderEntity entity);

	/**
	 *
	 * @param suffix
	 * @param orderNum
     * @return
     */
	public ActivityOrderEntity find(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param facePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
     * @param consumeCreditsStatus
     * @return
     */
	public int updateCreditsSuccess(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("activityOptionId")Long activityOptionId, 
			@Param("activityOptionName")String activityOptionName, 
			@Param("activityOptionType")String activityOptionType, 
			@Param("facePrice")String facePrice, 
			@Param("appItemId")Long appItemId, 
			@Param("itemId")Long itemId, 
			@Param("gid")Long gid, 
			@Param("gtype")String gtype, 
			@Param("couponId")Long couponId,
			@Param("consumeCreditsStatus")int consumeCreditsStatus);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param facePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
     * @param consumeCreditsStatus
     * @return
     */
	public int updateCreditsSuccessDowngrade(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("activityOptionId")Long activityOptionId, 
			@Param("activityOptionName")String activityOptionName, 
			@Param("activityOptionType")String activityOptionType, 
			@Param("facePrice")String facePrice, 
			@Param("appItemId")Long appItemId, 
			@Param("itemId")Long itemId, 
			@Param("gid")Long gid, 
			@Param("gtype")String gtype, 
			@Param("couponId")Long couponId,
			@Param("consumeCreditsStatus")int consumeCreditsStatus);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param facePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
	 * @param error4admin
	 * @param error4developer
     * @param error4consumer
     * @param consumeCreditsStatus
     * @return
     */
	public int updateCreditsFail(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("activityOptionId")Long activityOptionId, 
			@Param("activityOptionName")String activityOptionName, 
			@Param("activityOptionType")String activityOptionType, 
			@Param("facePrice")String facePrice, 
			@Param("appItemId")Long appItemId, 
			@Param("itemId")Long itemId, 
			@Param("gid")Long gid, 
			@Param("gtype")String gtype, 
			@Param("couponId")Long couponId, 
			@Param("error4admin")String error4admin, 
			@Param("error4developer")String error4developer, 
			@Param("error4consumer")String error4consumer,
			@Param("consumeCreditsStatus")int consumeCreditsStatus);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param facePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
     * @param addCreditsStatus
     * @return
     */
	public int updateAddCreditsSuccess(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("activityOptionId")Long activityOptionId, 
			@Param("activityOptionName")String activityOptionName, 
			@Param("activityOptionType")String activityOptionType, 
			@Param("facePrice")String facePrice, 
			@Param("appItemId")Long appItemId, 
			@Param("itemId")Long itemId, 
			@Param("gid")Long gid, 
			@Param("gtype")String gtype, 
			@Param("couponId")Long couponId,
			@Param("addCreditsStatus")int addCreditsStatus);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param facePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
	 * @param error4admin
	 * @param error4developer
     * @param error4consumer
     * @param addCreditsStatus
     * @return
     */
	public int updateAddCreditsFail(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("activityOptionId")Long activityOptionId, 
			@Param("activityOptionName")String activityOptionName, 
			@Param("activityOptionType")String activityOptionType, 
			@Param("facePrice")String facePrice, 
			@Param("appItemId")Long appItemId, 
			@Param("itemId")Long itemId, 
			@Param("gid")Long gid, 
			@Param("gtype")String gtype, 
			@Param("couponId")Long couponId, 
			@Param("error4admin")String error4admin, 
			@Param("error4developer")String error4developer, 
			@Param("error4consumer")String error4consumer,
			@Param("addCreditsStatus")int addCreditsStatus);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param status
     * @return
     */
	int addCreditsStatusToProcessing(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("status")int status);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param exchangeStatus
     * @return
     */
	public int updateExchangeStatus(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("exchangeStatus")int exchangeStatus);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param bizId
     * @return
     */
	public int updateDeveloperBizId(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("bizId")String bizId);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param bizId
     * @return
     */
	public int updateAddDeveloperBizId(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("bizId")String bizId);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param mainOrderNum
     * @return
     */
	public int updateMainOrderNum(@Param("suffix")String suffix,
			@Param("orderNum")String orderNum, 
			@Param("mainOrderNum")String mainOrderNum);

	/**
	 *
	 * @param suffix
	 * @param consumerId
	 * @param duibaActivityId
	 * @param activityType
     * @return
     */
	public int countConsumerJoinNum(@Param("suffix")String suffix,
			@Param("consumerId")long consumerId, 
			@Param("duibaActivityId")long duibaActivityId, 
			@Param("activityType")String activityType);

	/**
	 *
	 * @param suffix
	 * @param consumerId
	 * @param duibaActivityIds
	 * @param activityType
     * @return
     */
	public List<ActivityOrderEntity> findConsumerJoinList(@Param("suffix")String suffix,
			@Param("consumerId")long consumerId, 
			@Param("duibaActivityIds")List<Long> duibaActivityIds, 
			@Param("activityType")String activityType);

	/**
	 *
	 * @param suffix
	 * @param consumerId
	 * @param duibaActivityId
	 * @param activityType
	 * @param start
     * @param end
     * @return
     */
	ActivityOrderEntity findConsumerDuibaActivity4day(@Param("suffix")String suffix,
			@Param("consumerId")long consumerId, 
			@Param("duibaActivityId")Long duibaActivityId, 
			@Param("activityType")String activityType,
			@Param("start")String start, 
			@Param("end")String end);

	/**
	 *
	 * @param suffix
	 * @param orderNums
     * @return
     */
	public List<ActivityOrderEntity> findByOrderNums(@Param("suffix")String suffix,
			@Param("orderNums") List<String> orderNums);

	/**
	 *
	 * @param consumerId
	 * @param appId
	 * @param activityType
	 * @param suffix
     * @return
     */
	public List<Long> findOptionIds(@Param("consumerId")Long consumerId, 
			@Param("appId")Long appId, 
			@Param("activityType")String activityType,
			@Param("suffix")String suffix);

	/**
	 *
	 * @param suffix
	 * @param orderNum
	 * @param addCredits
     * @return
     */
	int updateAddCredits(
			@Param("suffix")String suffix,
			@Param("orderNum") String orderNum,
			@Param("addCredits") Long addCredits);
	
	
} 
