package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.api.dto.SupplierProductDto;
import cn.com.duiba.order.center.biz.constant.ConfigConstant;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.dao.credits.SupplierProductsDao;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * 支付宝订单创建
 */
@Component
public class AliPayCreator extends BaseCreator {


	@Autowired
	private TopicConstant topicConstant;

	@Autowired
	private ConfigConstant configConstant;

	@Autowired
	private MessageService messageService;
	
	@Autowired
	private SupplierProductsDao supplierProductsDao;

	/**
	 * 支付宝-普通兑换-下单操作
	 * 
	 * @param order 订单对象
	 * @param params http参数
	 * @throws Exception
	 */
	public void createOrder(OrdersEntity order, RequestParams params) throws Exception {

		if (order == null) {
			throw new BusinessException("订单为空");
		}
		
		Long supplierProductId = getSupplierId();
		if(supplierProductId == null){
			throw new BusinessException("没有供应商");
		}

		// 创建订单
		takeOrder(order);

		// 订单异步处理消息
		OrderCreateContext orderCreateContext = new OrderCreateContext();
		orderCreateContext.setOrderId(order.getId());
		orderCreateContext.setConsumerId(order.getConsumerId());
		orderCreateContext.setParams(params);
		orderCreateContext.setChargeMode(order.getChargeMode());
		orderCreateContext.setSupplierProductId(supplierProductId);
		orderCreateContext.setTimestamp(System.currentTimeMillis());
		messageService.sendMsg(topicConstant.getAlipayOrderCreatePart(),
				JSONObject.toJSONString(orderCreateContext));
	}

	/**
	 * 根据第三方支付和官方支付的权重，获取对应队列名称
	 * @return
	 */
	private Long getSupplierId() {
		int alipayWeitht = Integer.parseInt(configConstant.alipayWeight);
		int thirdWeight = Integer.parseInt(configConstant.thirdpayWeight);
		SupplierProductEntity alipaySp = supplierProductsDao.findBySupplier(SupplierProductDto.SupplierAlipayOfficial);
		if(alipaySp == null){
			return null;
		}
		if (thirdWeight == 0) {
			return alipaySp.getId();
		}
		
		SupplierProductEntity thirdpaySp = supplierProductsDao.findBySupplier(SupplierProductDto.SupplierThirdPayOfficial);
		if(thirdpaySp == null){
			return alipaySp.getId();
		}
		Map<Long, Integer> suppliers = new HashMap<>();
		suppliers.put(alipaySp.getId(), alipayWeitht);
		suppliers.put(thirdpaySp.getId(), thirdWeight);
		
		//加权随机数算法获取选择对象
		int sum = alipayWeitht + thirdWeight;
		Integer rand = new Random().nextInt(sum) + 1;
		for (Map.Entry<Long, Integer> entry : suppliers.entrySet()) {
			rand -= entry.getValue();
			if (rand <= 0) {
				return entry.getKey();
			}
		}
		return alipaySp.getId();
	}
	
//	public static void main(String[] args) throws InterruptedException {
//		int alipay = 0, third = 0;
//		Map<String, Integer> suppliers = new HashMap<>();
//		suppliers.put("alipay", 99);
//		suppliers.put("third", 1);
//		
//		int sum = 100;
//		for(int i=0;i<6752;i++){
//			Integer rand = new Random().nextInt(sum) + 1;
//			String key = null;
//			for (Map.Entry<String, Integer> entry : suppliers.entrySet()) {
//				rand -= entry.getValue();
//				if (rand <= 0) {
//					key = entry.getKey();
//					break;
//				}
//			}
//			if("alipay".equals(key)){
//				alipay++;
//			}else if("third".equals(key)){
//				third++;
//			}
//		}
//		System.out.println("alipay = " + alipay);
//		System.out.println("third = " + third);
//	}
}
