package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.biz.dao.BaseActivityOrderDaoTool;
import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.dao.activityhouse.ActivityOrderHouseDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.tool.TradeCenterException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 活动订单处理类
 */
@Component
public class ActivityOrderHandle {

	@Resource
	private RemoteIDMakerService remoteIDMakerService;
	
	@Autowired
	private ActivityOrderDao activityOrderDao;
	@Autowired
	private ActivityOrderHouseDao activityOrderHouseDao;


	/**
	 *
	 * @param entity
     */
	public void insert(ActivityOrderEntity entity) {
		DubboResult<Long> ret = remoteIDMakerService.getNextID(IDMakerTypeEnums.ACTIVITY_ORDER.getType());
		if (!ret.isSuccess()) {
			throw new TradeCenterException("ID生成失败");
		}
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(entity.getConsumerId());
		String orderNum = ret.getResult() + suffix;
		entity.setSuffix(suffix);
		entity.setOrderNum(orderNum);
		activityOrderDao.insert(entity);
	}

	/**
	 *
	 * @param orderNum
	 * @return
     */
	public ActivityOrderEntity find(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.find(suffix,orderNum);
	}

	/**
	 *
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param activityOptionFacePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
     * @param couponId
     * @return
     */
	public int updateCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateCreditsSuccess(suffix,orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId,ActivityOrderDto.ConsumeCreditsSuccess);
	}

	/**
	 *
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param activityOptionFacePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
     * @param couponId
     * @return
     */
	public int updateCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateCreditsSuccessDowngrade(suffix,orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId,ActivityOrderDto.ConsumeCreditsSuccess);
	}

	/**
	 *
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param activityOptionFacePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
	 * @param error4admin
	 * @param error4developer
     * @param error4consumer
     * @return
     */
	public int updateCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		error4admin = StringUtils.substring(error4admin, 0, 200);
		error4developer = StringUtils.substring(error4developer, 0, 200);
		error4consumer = StringUtils.substring(error4consumer, 0, 200);
		return activityOrderDao.updateCreditsFail(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer, ActivityOrderDto.ConsumeCreditsFail);
	}

	/**
	 *
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param activityOptionFacePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
     * @param couponId
     * @return
     */
	public int updateAddCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateAddCreditsSuccess(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, ActivityOrderDto.AddCreditsSuccess);
	}

	/**
	 *
	 * @param orderNum
	 * @param activityOptionId
	 * @param activityOptionName
	 * @param activityOptionType
	 * @param activityOptionFacePrice
	 * @param appItemId
	 * @param itemId
	 * @param gid
	 * @param gtype
	 * @param couponId
	 * @param error4admin
	 * @param error4developer
     * @param error4consumer
     * @return
     */
	public int updateAddCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		error4admin = StringUtils.substring(error4admin, 0, 200);
		error4developer = StringUtils.substring(error4developer, 0, 200);
		error4consumer = StringUtils.substring(error4consumer, 0, 200);
		return activityOrderDao.updateAddCreditsFail(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer, ActivityOrderDto.AddCreditsFail);
	}

	/**
	 *
	 * @param orderNum
	 * @return
     */
	public int addCreditsStatusToProcessing(String orderNum){
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.addCreditsStatusToProcessing(suffix, orderNum, ActivityOrderDto.AddCreditsProcessing);
	}

	/**
	 *
	 * @param orderNum
	 * @return
     */
	public int updateExchangeStatusWait(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeWait);
	}

	/**
	 *
	 * @param orderNum
	 * @return
     */
	public int updateExchangeStatusSuccess(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeSuccess);
	}

	/**
	 *
	 * @param orderNum
	 * @return
     */
	public int updateExchangeStatusFail(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeFail);
	}

	/**
	 *
	 * @param orderNum
	 * @return
     */
	public int updateExchangeStatusOverdue(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeOverdue);
	}

	/**
	 *
	 * @param orderNum
	 * @param bizId
     * @return
     */
	public int updateDeveloperBizId(String orderNum, String bizId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateDeveloperBizId(suffix,orderNum, bizId);
	}

	/**
	 *
	 * @param orderNum
	 * @param bizId
     * @return
     */
	public int updateAddDeveloperBizId(String orderNum, String bizId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateAddDeveloperBizId(suffix,orderNum, bizId);
	}

	/**
	 *
	 * @param orderNum
	 * @param mainOrderNum
     * @return
     */
	public int updateMainOrderNum(String orderNum, String mainOrderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateMainOrderNum(suffix, orderNum, mainOrderNum);
	}

	/**
	 *
	 * @param consumerId
	 * @param duibaActivityId
	 * @param activityType
     * @return
     */
	public int countConsumerJoinNum(long consumerId, long duibaActivityId, String activityType) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.countConsumerJoinNum(suffix, consumerId, duibaActivityId, activityType);
	}

	/**
	 *
	 * @param consumerId
	 * @param duibaActivityIds
	 * @param activityType
     * @return
     */
	public List<ActivityOrderEntity> findConsumerJoinList(long consumerId, List<Long> duibaActivityIds, String activityType) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.findConsumerJoinList(suffix, consumerId, duibaActivityIds, activityType);
	}

	/**
	 *
	 * @param consumerId
	 * @param duibaActivityId
	 * @param activityType
	 * @param start
	 * @param end
     * @return
     */
	public ActivityOrderEntity findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType,
			String start, String end){
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.findConsumerDuibaActivity4day(suffix,consumerId, duibaActivityId, activityType, start, end);
	}

	/**
	 *
	 * @param consumerId
	 * @param orderNums
     * @return
     */
	public List<ActivityOrderEntity> findByOrderNums(long consumerId, List<String> orderNums) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.findByOrderNums(suffix, orderNums);
	}

	/**
	 *
	 * @param consumerId
	 * @param appId
	 * @param activityType
     * @return
     */
	public List<Long> findOptionIds(Long consumerId, Long appId, String activityType){
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.findOptionIds(consumerId, appId, activityType, suffix);
	}

	/**
	 *
	 * @param orderNum
	 * @param credits
     * @return
     */
	public int updateAddCredits(String orderNum, Long credits){
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateAddCredits(suffix, orderNum, credits);
	}

	/**
	 *
	 * @param expirationTime
	 * @param activityType
     * @return
     */
	public List<String> findByExpirationTime(String expirationTime,String activityType){
		return activityOrderHouseDao.findByExpirationTime(expirationTime,activityType);
	}

	/**
	 *
	 * @param consumerId
	 * @param appId
	 * @param activityType
     * @return
     */
	public List<Long> findOptionIdsHouse(Long consumerId, Long appId, String activityType){
		return activityOrderHouseDao.findOptionIds(consumerId, appId, activityType);
	}

	/**
	 *
	 * @param queryMap
	 * @return
     */
	public List<ActivityOrderEntity> findByAppIdWithPage(Map<String, Object> queryMap) {
		return activityOrderHouseDao.findByAppIdWithPage(queryMap);
	}

	/**
	 *
	 * @param queryMap
	 * @return
     */
	public int getCountByAppId(Map<String, Object> queryMap) {
		return activityOrderHouseDao.getCountByAppId(queryMap);
	}

	/**
	 *
	 * @param activityIds
	 * @param appId
     * @return
     */
	public List<Map<String,Long>> findFailByActivity4App(List<Long> activityIds, Long appId) {
		return activityOrderHouseDao.findFailByActivity4App(activityIds, appId);
	}
}
