package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseConsumerRecordTool;
import cn.com.duiba.order.center.biz.dao.consumerrecord.ConsumerExchangeRecordDao;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordSequenceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/10/11.
 */
@Component
public class ConsumerExchangeRecordHandle {

    @Autowired
    private ConsumerExchangeRecordDao consumerExchangeRecordDao;

	/**
	 *
	 * @param entity
     */
    public void insert(ConsumerExchangeRecordEntity entity) {
        entity.setId(getSequenceID(new ConsumerExchangeRecordSequenceEntity()));
        entity.setTableName(BaseConsumerRecordTool.get1024TableName(entity.getConsumerId()));
        consumerExchangeRecordDao.insert(entity);
    }

	/**
	 *
	 * @param map
	 * @return
     */
    public ConsumerExchangeRecordEntity selectOneByMapCondition(Map<String, Object> map) {
    	Object o = map.get("consumerId");
    	if(o == null){
    		return null;
    	}
    	long consumerId = (Long)o;
    	String tableName = BaseConsumerRecordTool.get1024TableName(consumerId);
    	map.put("tableName", tableName);
		return consumerExchangeRecordDao.selectOneByMapCondition(map);
	}

	/**
	 *
	 * @param map
	 * @return
     */
	public List<ConsumerExchangeRecordEntity> selectListByMapCondition(Map<String, Object> map) {
		Object o = map.get("consumerId");
    	if(o == null){
    		return Collections.emptyList();
    	}
    	long consumerId = (Long)o;
    	String tableName = BaseConsumerRecordTool.get1024TableName(consumerId);
    	map.put("tableName", tableName);
		return consumerExchangeRecordDao.selectListByMapCondition(map);
	}

	/**
	 *
	 * @param map
	 * @return
     */
	public List<ConsumerExchangeRecordEntity> selectPageListByMapCondition(Map<String, Object> map) {
		Object o = map.get("consumerId");
    	if(o == null){
    		return null;
    	}
    	long consumerId = (Long)o;
    	String tableName = BaseConsumerRecordTool.get1024TableName(consumerId);
    	map.put("tableName", tableName);
		return consumerExchangeRecordDao.selectPageListByMapCondition(map);
	}

	/**
	 *
	 * @param entity
	 * @return
     */
	public int update(ConsumerExchangeRecordEntity entity) {
		Long consumerId = entity.getConsumerId();
		if(consumerId == null){
			return 0;
		}
		String tableName = BaseConsumerRecordTool.get1024TableName(consumerId);
		entity.setTableName(tableName);
		return consumerExchangeRecordDao.update(entity);
	}

	/**
	 *
	 * @param consumerExchangeRecordSequenceEntity
	 * @return
     */
    public long getSequenceID(ConsumerExchangeRecordSequenceEntity consumerExchangeRecordSequenceEntity) {
        consumerExchangeRecordDao.getSequenceID(consumerExchangeRecordSequenceEntity);
        return consumerExchangeRecordSequenceEntity.getId();
    }
}
