package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.guess.GuessOrdersDao;
import cn.com.duiba.order.center.biz.entity.GuessOrdersEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by yansen on 16/10/8.
 */
@Component
public class GuessOrdersHandle {

    @Autowired
    private GuessOrdersDao guessOrdersDao;

    /**
     *
     * @param guessOrdersEntity
     */
    public void insert(GuessOrdersEntity guessOrdersEntity) {
        String suffix = BaseOrderTool.getTableSuffix(guessOrdersEntity.getConsumerId());
        guessOrdersDao.insert(guessOrdersEntity, suffix);
    }

    /**
     *
     * @param consumerId
     * @param id
     * @return
     */
    public GuessOrdersEntity findById(Long consumerId, Long id) {
        String suffix = BaseOrderTool.getTableSuffix(consumerId);
        return guessOrdersDao.findById(id, suffix);
    }
}
