package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersJumpDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by yansen on 16/9/21.
 */
@Component
public class MainOrderJumpHandle {

    @Autowired
    private OrdersJumpDao ordersJumpDao;

    /**
     * 创建订单started->兑吧付款complete
     * @param orderId
     * @param consumerId
     * @return
     */
    public int jumpCreateStarted2DuibaPayComplete(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersJumpDao.jumpCreateStarted2DuibaPayComplete(orderId,consumerId,tableName);
    }

    /**
     * 创建订单started->开发都付款完成 complete
     * @param orderId
     * @param consumerId
     * @return
     */
    public int jumpCreateStarted2DeveloperPayComplete(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersJumpDao.jumpCreateStarted2DeveloperPayComplete(orderId,consumerId,tableName);
    }


    /**
     * 开发者付款  started-> 兑吧付款完成 complete
     * @param orderId
     * @param consumerId
     * @return
     */
    public int jumpDeveloperPayStarted2DuibaPayComplete(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersJumpDao.jumpDeveloperPayStarted2DuibaPayComplete(orderId,consumerId,tableName);
    }
    /**
     * 扣积分started->用户付款complete
     * @param orderId
     * @param consumerId
     * @return
     */
    public int jumpConsumeCreditsStarted2ConsumerPayComplete(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersJumpDao.jumpConsumeCreditsStarted2ConsumerPayComplete(orderId,consumerId,tableName);
    }
    /**
     * 扣积分started->审核complete
     * @param orderId
     * @param consumerId
     * @return
     */
    public int jumpConsumeCreditsStarted2AuditComplete(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersJumpDao.jumpConsumeCreditsStarted2AuditComplete(orderId,consumerId,tableName);
    }
    /**
     * 上游兑换started->售后complete
     * @param orderId
     * @param consumerId
     * @return
     */
    public int jumpSupplierExchangeStarted2AfterSendComplete(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersJumpDao.jumpSupplierExchangeStarted2AfterSendComplete(orderId,consumerId,tableName);
    }
}
