package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersTextChangeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
@Component
public class OrdersTextChangeHandle {


    @Autowired
    private OrdersTextChangeDao ordersTextChangeDao;


    /**
     * 更新订单错误信息，状态，错误类型
     * @param orderId
     * @param consumerId
     * @param failType
     * @param errorMessage
     * @param error4Consumer
     * @param error4Developer
     * @param error4Admin
     * @return
     */

    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage,
                                                 String error4Consumer, String error4Developer, String error4Admin) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        Integer ret= ordersTextChangeDao.updateErrorMessageAndFailType(orderId, consumerId, failType, errorMessage, error4Consumer, error4Developer, error4Admin, tableName);
        return ret;
    }

    /**
     * 更新最后发送时间
     * @param orderId
     * @param consumerId
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateLastSendTime(orderId,consumerId,lastSendTime,tableName);
    }

    /**
     * 更新开发者订单号
     * @param orderId
     * @param consumerId
     * @param developBizId
     * @return
     */
    public Integer updateDevelopBizId(Long orderId,Long consumerId, String developBizId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateDevelopBizId(orderId,consumerId,developBizId,tableName);
    }

    /**
     * 更新上游订单
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @return
     */
    public Integer updateSupplierOrderId(Long orderId,  Long consumerId, Long supplierOrderId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateSupplierOrderId(orderId,consumerId,supplierOrderId,tableName);
    }

    /**
     * 释放一张优惠券
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer releaseCouponByOrderId(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.releaseCouponByOrderId(orderId,consumerId,tableName);
    }

    /**
     * 下订单,更新优惠券ID
     * @param orderId
     * @param consumerId
     * @param couponId
     * @return
     */
    public Integer updateCouponId(Long orderId,Long consumerId,Long couponId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateCouponId(orderId,consumerId,couponId,tableName);
    }

    /**
     * 更新子订单ID
     * @param orderId
     * @param consumerId
     * @param subId
     * @return
     */
    public Integer updateSubOrderIdById(Long orderId,Long consumerId, Long subId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateSubOrderIdById(orderId,consumerId,subId,tableName);
    }
}
