package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.service.consumerrecord.ConsumerExchangeRecordService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/9/30.
 */
@Service
public class RemoteConsumerExchangeRecordServiceImpl implements RemoteConsumerExchangeRecordService {
    @Autowired
    private ConsumerExchangeRecordService consumerExchangeRecordService;
    
    @Override
    public DubboResult<ConsumerExchangeRecordDto> insert(ConsumerExchangeRecordDto consumerExchangeRecordDto) {
        consumerExchangeRecordService.insert(consumerExchangeRecordDto);
        return DubboResult.successResult(consumerExchangeRecordDto);
    }

	@Override
	public DubboResult<ConsumerExchangeRecordDto> selectOneByMapCondition(Map<String, Object> map) {
		ConsumerExchangeRecordEntity entity = consumerExchangeRecordService.selectOneByMapCondition(map);
		ConsumerExchangeRecordDto dto = BeanUtils.copy(entity, ConsumerExchangeRecordDto.class);
		return DubboResult.successResult(dto);
	}

	@Override
	public DubboResult<List<ConsumerExchangeRecordDto>> selectListByMapCondition(Map<String, Object> map) {
		List<ConsumerExchangeRecordEntity> ret = consumerExchangeRecordService.selectListByMapCondition(map);
		List<ConsumerExchangeRecordDto> dtos = new ArrayList<>();
		for(ConsumerExchangeRecordEntity entity : ret){
			ConsumerExchangeRecordDto dto = BeanUtils.copy(entity, ConsumerExchangeRecordDto.class);
			dtos.add(dto);
		}
		return DubboResult.successResult(dtos);
	}

	@Override
	public DubboResult<List<ConsumerExchangeRecordDto>> selectPageListByMapCondition(Map<String, Object> map) {
		List<ConsumerExchangeRecordEntity> ret = consumerExchangeRecordService.selectPageListByMapCondition(map);
		List<ConsumerExchangeRecordDto> dtos = new ArrayList<>();
		for(ConsumerExchangeRecordEntity entity : ret){
			ConsumerExchangeRecordDto dto = BeanUtils.copy(entity, ConsumerExchangeRecordDto.class);
			dtos.add(dto);
		}
		return DubboResult.successResult(dtos);
	}

	@Override
	public DubboResult<Boolean> update(ConsumerExchangeRecordDto dto) {
		ConsumerExchangeRecordEntity entity= BeanUtils.copy(dto,ConsumerExchangeRecordEntity.class);
		Boolean ret = consumerExchangeRecordService.update(entity);
		return DubboResult.successResult(ret);
	}
    
	
}
