package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerOrderSimpleService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrderSimpleService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class RemoteConsumerOrderSimpleServiceImpl implements RemoteConsumerOrderSimpleService {

    @Autowired
    private OrderSimpleService orderSimpleService;

    /**
     * 根据订单id和用户id查询订单
     *
     * @param id
     * @param consumerId
     * @return
     */
    @Override
    public DubboResult<OrdersDto> findById(Long id, Long consumerId) {
        return DubboResult.successResult(orderSimpleService.findById(id, consumerId));
    }

    /**
     * 根据订单唯一编号查询订单
     *
     * @param orderNum
     * @return
     */
    @Override
    public DubboResult<OrdersDto> findByOrderNum(String orderNum) {
        return DubboResult.successResult(orderSimpleService.findByOrderNum(orderNum));
    }

    /**
     * 通过for update的方式查询订单
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    @Override
    public DubboResult<OrdersDto> select4updatelock(Long orderId, Long consumerId) {
        return DubboResult.successResult(orderSimpleService.select4updatelock(orderId,consumerId));
    }

    /**
     * 改用发号器的订单使用查询分库,改造前的查询house库
     * @param id
     * @return
     */
    @Override
    public DubboResult<OrdersDto> findById(Long id){
        return DubboResult.successResult(orderSimpleService.findById(id));
    }
}

