package cn.com.duiba.order.center.biz.remoteservice;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.api.remoteservice.RemoteExchangeService;
import cn.com.duiba.order.center.biz.entity.AmbSubOrdersEntity;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.exchangecreator.AliPayCreator;
import cn.com.duiba.order.center.biz.exchangecreator.CouponCreator;
import cn.com.duiba.order.center.biz.exchangecreator.ObjectCreator;
import cn.com.duiba.order.center.biz.exchangecreator.PcgCouponCreator;
import cn.com.duiba.order.center.biz.exchangecreator.PhoneBillCreator;
import cn.com.duiba.order.center.biz.exchangecreator.PhoneFlowCreator;
import cn.com.duiba.order.center.biz.exchangecreator.QBcreator;
import cn.com.duiba.order.center.biz.exchangecreator.VirtualCreator;
import cn.com.duiba.order.center.biz.tool.TradeCenterException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;


/**
 * @author yansen
 */
@Service
public class RemoteExchangeServiceImpl implements RemoteExchangeService {

	@Autowired
	private QBcreator qBcreator;
	
	@Autowired
	private AliPayCreator aliPayCreator;
	
	@Autowired
	private PhoneBillCreator phoneBillCreator;
	
	@Autowired
	private CouponCreator couponCreator;
	@Autowired
	private PcgCouponCreator pcgCouponCreator;
	@Autowired
	private VirtualCreator virtualCreator;
	@Autowired
	private PhoneFlowCreator phoneFlowCreator;
	@Autowired
	private ObjectCreator objectCreator;
	
	private static final Logger log = JsonLoggerFactory.getLogger(RemoteExchangeServiceImpl.class);
	
	@Override
	public DubboResult<OrdersDto> createQbOrder(OrdersDto orderDto,
			Long supplierProductId, RequestParams params) {
		OrdersEntity order = BeanUtils.copy(orderDto, OrdersEntity.class);
		try {
			qBcreator.createOrder(order, supplierProductId, params);
			orderDto.setId(order.getId());
			orderDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(orderDto);
		} catch (Exception e) {
			log.error("Qb exchange error = ",e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<OrdersDto> createAliPayOrder(OrdersDto orderDto, RequestParams params) {
		OrdersEntity order = BeanUtils.copy(orderDto, OrdersEntity.class);
		try {
			aliPayCreator.createOrder(order, params);
			orderDto.setId(order.getId());
			orderDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(orderDto);
		} catch (Exception e) {
			log.error("alipay exchange error = " ,e);
			return DubboResult.failResult(e.getMessage());
		}
	}
	
	@Override
	public DubboResult<OrdersDto> createPhoneBillOrder(OrdersDto orderDto,
			Long supplierProductId, RequestParams params) {
		OrdersEntity order = BeanUtils.copy(orderDto, OrdersEntity.class);
		try {
			phoneBillCreator.createOrder(order, supplierProductId, params);
			orderDto.setId(order.getId());
			orderDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(orderDto);
		} catch (Exception e) {
			log.error("phonebill exchange error = " ,e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<OrdersDto> createCouponOrder(OrdersDto orderDto,
			Long couponId, RequestParams params) {
		OrdersEntity order = BeanUtils.copy(orderDto, OrdersEntity.class);
		try {
			couponCreator.createOrder(order, couponId, params);
			orderDto.setId(order.getId());
			orderDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(orderDto);
		} catch (Exception e) {
			log.error("coupon exchange error = " ,e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult> createPcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param){
		RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult result=new RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult();
		OrdersDto order;
		try {
			order = pcgCouponCreator.takePcgOrder(param);

			if(order!=null && order.getId()!=null){
				result.setSuccess(true);
				result.setOrderId(order.getId());
				return DubboResult.successResult(result);
			}
			throw new TradeCenterException("未知错误");
		} catch (Exception e) {
			log.error("RemotePlatformCouponGoodsTakeOrderServiceImpl.takeOrder error,orderNum="+param.getOrderNum()+",pcgId="+param.getPcgId(),e);
			result.setSuccess(false);
			result.setNeedRollback(true);
		}
		return DubboResult.successResult(result);
	}

	/**
	 *
	 * @param ordersDto
	 * @param ambSubOrdersDto
	 * @param degreeStr
	 * @param params
     * @return
     */
	@Override
	public DubboResult<OrdersDto> createVirtualOrder(OrdersDto ordersDto, AmbSubOrdersDto ambSubOrdersDto, String degreeStr , RequestParams params){
		OrdersEntity order = BeanUtils.copy(ordersDto, OrdersEntity.class);
		AmbSubOrdersEntity ambSubOrdersEntity=null;
		if(ambSubOrdersDto!=null){
			ambSubOrdersEntity=BeanUtils.copy(ambSubOrdersDto,AmbSubOrdersEntity.class);
		}
		try {
			virtualCreator.createOrder(order,ambSubOrdersEntity,degreeStr,params);
			ordersDto.setId(order.getId());
			ordersDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(ordersDto);
		} catch (Exception e) {
			log.error("virtual exchange error = " ,e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 *
	 * @param orderDto
	 * @param supplierProductId
	 * @param params
     * @return
     */
	@Override
	public DubboResult<OrdersDto> createPhoneflowOrder(OrdersDto orderDto,
													   Long supplierProductId, RequestParams params) {
		OrdersEntity order = BeanUtils.copy(orderDto, OrdersEntity.class);
		try {
			phoneFlowCreator.createOrder(order, supplierProductId, params);
			orderDto.setId(order.getId());
			orderDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(orderDto);
		} catch (Exception e) {
			log.error("phonebill exchange error = " ,e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 *
	 * @param orderDto
	 * @param params
     * @return
     */
	@Override
	public DubboResult<OrdersDto> createObjectOrder(OrdersDto orderDto, AmbSubOrdersDto ambSubOrdersDto,RequestParams params){
		OrdersEntity order = BeanUtils.copy(orderDto, OrdersEntity.class);
		try {
			AmbSubOrdersEntity ambSubOrdersEntity=null;
			if(ambSubOrdersDto!=null){
				ambSubOrdersEntity=BeanUtils.copy(ambSubOrdersDto,AmbSubOrdersEntity.class);
			}
			objectCreator.createOrder(order,ambSubOrdersEntity,params);
			orderDto.setId(order.getId());
			orderDto.setOrderNum(order.getOrderNum());
			return DubboResult.successResult(orderDto);
		} catch (Exception e) {
			log.error("createObjectOrder exchange error = " ,e);
			return DubboResult.failResult(e.getMessage());
		}
	}
}
